/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.log;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.management.StandardMBean;
import org.sonatype.nexus.log.DefaultLogConfiguration;
import org.sonatype.nexus.log.LogConfiguration;
import org.sonatype.nexus.log.LogManager;
import org.sonatype.nexus.log.LogManagerMBean;
import org.sonatype.nexus.log.LoggerLevel;

public class DefaultLogManagerMBean
extends StandardMBean
implements LogManagerMBean {
    private final LogManager logManager;

    public DefaultLogManagerMBean(LogManager logManager) {
        super(LogManagerMBean.class, false);
        this.logManager = (LogManager)Preconditions.checkNotNull((Object)logManager, (Object)"Managed LogManager instance cannot be null!");
    }

    @Override
    public String getRootLoggerLevel() throws IOException {
        LogConfiguration logConfiguration = this.logManager.getConfiguration();
        return logConfiguration.getRootLoggerLevel();
    }

    @Override
    public void makeRootLoggerLevelOff() throws IOException {
        this.setRootLoggerLevel(LoggerLevel.OFF);
    }

    @Override
    public void makeRootLoggerLevelTrace() throws IOException {
        this.setRootLoggerLevel(LoggerLevel.TRACE);
    }

    @Override
    public void makeRootLoggerLevelDebug() throws IOException {
        this.setRootLoggerLevel(LoggerLevel.DEBUG);
    }

    @Override
    public void makeRootLoggerLevelInfo() throws IOException {
        this.setRootLoggerLevel(LoggerLevel.INFO);
    }

    @Override
    public void makeRootLoggerLevelWarn() throws IOException {
        this.setRootLoggerLevel(LoggerLevel.WARN);
    }

    @Override
    public void makeRootLoggerLevelError() throws IOException {
        this.setRootLoggerLevel(LoggerLevel.ERROR);
    }

    @Override
    public void makeRootLoggerLevelDefault() throws IOException {
        this.makeRootLoggerLevelInfo();
    }

    protected void setRootLoggerLevel(LoggerLevel value) throws IOException {
        LogConfiguration oldConfiguration = this.logManager.getConfiguration();
        DefaultLogConfiguration newConfiguration = new DefaultLogConfiguration();
        newConfiguration.setFileAppenderLocation(oldConfiguration.getFileAppenderLocation());
        newConfiguration.setFileAppenderPattern(oldConfiguration.getFileAppenderPattern());
        newConfiguration.setRootLoggerAppenders(oldConfiguration.getRootLoggerAppenders());
        newConfiguration.setRootLoggerLevel(value.name());
        this.logManager.setConfiguration(newConfiguration);
    }
}

