/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.jsecurity.realms;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.security.model.CPrivilege;
import org.sonatype.security.model.CProperty;
import org.sonatype.security.realms.privileges.AbstractPrivilegeDescriptor;
import org.sonatype.security.realms.privileges.PrivilegeDescriptor;
import org.sonatype.security.realms.privileges.PrivilegePropertyDescriptor;
import org.sonatype.security.realms.validator.SecurityValidationContext;

@Singleton
@Named(value="TargetPrivilegeDescriptor")
public class TargetPrivilegeDescriptor
extends AbstractPrivilegeDescriptor
implements PrivilegeDescriptor {
    public static final String TYPE = "target";
    private final PrivilegePropertyDescriptor methodProperty;
    private final PrivilegePropertyDescriptor targetProperty;
    private final PrivilegePropertyDescriptor repositoryProperty;
    private final PrivilegePropertyDescriptor groupProperty;

    @Inject
    public TargetPrivilegeDescriptor(@Named(value="ApplicationPrivilegeMethodPropertyDescriptor") PrivilegePropertyDescriptor methodProperty, @Named(value="TargetPrivilegeRepositoryTargetPropertyDescriptor") PrivilegePropertyDescriptor targetProperty, @Named(value="TargetPrivilegeRepositoryPropertyDescriptor") PrivilegePropertyDescriptor repositoryProperty, @Named(value="TargetPrivilegeGroupPropertyDescriptor") PrivilegePropertyDescriptor groupProperty) {
        this.methodProperty = (PrivilegePropertyDescriptor)Preconditions.checkNotNull((Object)methodProperty);
        this.targetProperty = (PrivilegePropertyDescriptor)Preconditions.checkNotNull((Object)targetProperty);
        this.repositoryProperty = (PrivilegePropertyDescriptor)Preconditions.checkNotNull((Object)repositoryProperty);
        this.groupProperty = (PrivilegePropertyDescriptor)Preconditions.checkNotNull((Object)groupProperty);
    }

    public String getName() {
        return "Repository Target";
    }

    public List<PrivilegePropertyDescriptor> getPropertyDescriptors() {
        ArrayList<PrivilegePropertyDescriptor> propertyDescriptors = new ArrayList<PrivilegePropertyDescriptor>();
        propertyDescriptors.add(this.methodProperty);
        propertyDescriptors.add(this.targetProperty);
        propertyDescriptors.add(this.repositoryProperty);
        propertyDescriptors.add(this.groupProperty);
        return propertyDescriptors;
    }

    public String getType() {
        return TYPE;
    }

    public String buildPermission(CPrivilege privilege) {
        if (!TYPE.equals(privilege.getType())) {
            return null;
        }
        String method = this.getProperty(privilege, "method");
        String repositoryTargetId = this.getProperty(privilege, "repositoryTargetId");
        String repositoryId = this.getProperty(privilege, "repositoryId");
        String groupId = this.getProperty(privilege, "repositoryGroupId");
        StringBuilder basePermString = new StringBuilder();
        basePermString.append("nexus:target:");
        basePermString.append(repositoryTargetId);
        basePermString.append(":");
        StringBuilder postPermString = new StringBuilder();
        postPermString.append(":");
        if (StringUtils.isEmpty((String)method)) {
            postPermString.append("*");
        } else {
            postPermString.append(method);
        }
        if (!StringUtils.isEmpty((String)repositoryId)) {
            return basePermString + repositoryId + postPermString;
        }
        if (!StringUtils.isEmpty((String)groupId)) {
            return basePermString + groupId + postPermString;
        }
        return basePermString + "*" + postPermString;
    }

    public ValidationResponse validatePrivilege(CPrivilege privilege, SecurityValidationContext ctx, boolean update) {
        ValidationMessage message;
        ValidationResponse response = super.validatePrivilege(privilege, ctx, update);
        if (!TYPE.equals(privilege.getType())) {
            return response;
        }
        String method = null;
        String repositoryId = null;
        String repositoryTargetId = null;
        String repositoryGroupId = null;
        for (CProperty property : privilege.getProperties()) {
            if (property.getKey().equals("method")) {
                method = property.getValue();
                continue;
            }
            if (property.getKey().equals("repositoryId")) {
                repositoryId = property.getValue();
                continue;
            }
            if (property.getKey().equals("repositoryTargetId")) {
                repositoryTargetId = property.getValue();
                continue;
            }
            if (!property.getKey().equals("repositoryGroupId")) continue;
            repositoryGroupId = property.getValue();
        }
        if (StringUtils.isEmpty(repositoryTargetId)) {
            message = new ValidationMessage("repositoryTargetId", "Privilege ID '" + privilege.getId() + "' requires a repositoryTargetId.", "Repository Target is required.");
            response.addValidationError(message);
        }
        if (!StringUtils.isEmpty(repositoryId) && !StringUtils.isEmpty(repositoryGroupId)) {
            message = new ValidationMessage("repositoryId", "Privilege ID '" + privilege.getId() + "' cannot be assigned to both a group and repository." + "  Either assign a group, a repository or neither (which assigns to ALL repositories).", "Cannot select both a Repository and Repository Group.");
            response.addValidationError(message);
        }
        if (StringUtils.isEmpty(method)) {
            response.addValidationError("Method cannot be empty on a privilege!");
        } else {
            String[] methods = null;
            methods = method.contains(",") ? method.split(",") : new String[]{method};
            boolean valid = true;
            for (String singlemethod : methods) {
                if ("create".equals(singlemethod) || "delete".equals(singlemethod) || "read".equals(singlemethod) || "update".equals(singlemethod) || "*".equals(singlemethod)) continue;
                valid = false;
                break;
            }
            if (!valid) {
                ValidationMessage message2 = new ValidationMessage("method", "Privilege ID '" + privilege.getId() + "' Method is wrong! (Allowed methods are: create, delete, read and update)", "Invalid method selected.");
                response.addValidationError(message2);
            }
        }
        return response;
    }
}

