/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class DevModeResources {
    private static final List<File> resourceLocations = DevModeResources.initializeResourceLocations();

    private static List<File> initializeResourceLocations() {
        String directoriesToSearchProperty = System.getenv("NEXUS_RESOURCE_DIRS");
        if (directoriesToSearchProperty != null) {
            String[] segments;
            ArrayList directoriesToSearch = Lists.newArrayList();
            for (String segment : segments = directoriesToSearchProperty.split(",")) {
                File dir = new File(segment);
                if (!dir.exists() || !dir.isDirectory()) continue;
                directoriesToSearch.add(dir);
            }
            if (!directoriesToSearch.isEmpty()) {
                return directoriesToSearch;
            }
        }
        return null;
    }

    public static boolean hasResourceLocations() {
        return resourceLocations != null;
    }

    public static URL getResourceIfOnFileSystem(String path) {
        try {
            File file = DevModeResources.getFileIfOnFileSystem(path);
            if (file != null) {
                return file.getAbsoluteFile().toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static File getFileIfOnFileSystem(String path) {
        if (resourceLocations != null) {
            for (File dir : resourceLocations) {
                File file = new File(dir, path);
                if (!file.exists()) continue;
                return file;
            }
        }
        return null;
    }
}

