/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.guice;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.sisu.space.ClassSpace;
import org.sonatype.nexus.guice.StaticWebResource;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.web.WebResource;
import org.sonatype.nexus.web.WebResourceBundle;

@Singleton
public class StaticWebResourceBundle
implements WebResourceBundle {
    private final List<WebResource> staticResources = new ArrayList<WebResource>();

    @Inject
    public StaticWebResourceBundle(ClassSpace space, MimeSupport mimeSupport) {
        Enumeration e = space.findEntries("static/", null, true);
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            String path = StaticWebResourceBundle.getPublishedPath(url);
            if (path == null) continue;
            this.staticResources.add(new StaticWebResource(url, path, mimeSupport.guessMimeTypeFromPath(path)));
        }
    }

    @Override
    public List<WebResource> getResources() {
        return this.staticResources;
    }

    private static String getPublishedPath(URL resourceURL) {
        String path = resourceURL.toExternalForm();
        int index = path.indexOf("jar!/");
        if (index > 0) {
            return path.substring(index + 4);
        }
        index = path.indexOf("/static/");
        if (index > 0) {
            return path.substring(index);
        }
        return null;
    }
}

