/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.guice;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.sonatype.nexus.web.WebResource;

class StaticWebResource
implements WebResource {
    private final URL resourceURL;
    private final String publishedPath;
    private final boolean cacheable;
    private final String contentType;
    private final long size;
    private final long lastModified;

    public StaticWebResource(URL resourceURL, String publishedPath, String contentType) {
        this(resourceURL, publishedPath, contentType, true);
    }

    public StaticWebResource(URL resourceURL, String publishedPath, String contentType, boolean cacheable) {
        this.resourceURL = resourceURL;
        this.publishedPath = publishedPath;
        this.contentType = contentType;
        this.cacheable = cacheable;
        try {
            URLConnection urlConnection = resourceURL.openConnection();
            try (InputStream is = urlConnection.getInputStream();){
                long size = urlConnection.getContentLengthLong();
                if (size == -1L) {
                    size = urlConnection.getContentLength();
                }
                this.size = size;
                this.lastModified = urlConnection.getLastModified();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Static resource " + resourceURL + " inaccessible", e);
        }
    }

    @Override
    public String getPath() {
        return this.publishedPath;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.resourceURL.openStream();
    }

    public String toString() {
        return "StaticWebResource{url=" + this.resourceURL + '}';
    }
}

