/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.plexus.ComponentImpl;
import org.eclipse.sisu.plexus.PlexusTypeBinder;
import org.eclipse.sisu.plexus.PlexusTypeListener;
import org.eclipse.sisu.plexus.PlexusTypeVisitor;
import org.eclipse.sisu.space.SpaceModule;
import org.eclipse.sisu.space.SpaceVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.gossip.Level;
import org.sonatype.nexus.plugins.RepositoryType;
import org.sonatype.nexus.proxy.registry.RepositoryTypeDescriptor;
import org.sonatype.nexus.proxy.repository.Repository;

public final class NexusTypeBinder
implements PlexusTypeListener {
    public static final SpaceModule.Strategy STRATEGY = new SpaceModule.Strategy(){

        public SpaceVisitor visitor(Binder binder) {
            return new PlexusTypeVisitor((PlexusTypeListener)new NexusTypeBinder(binder, (PlexusTypeListener)new PlexusTypeBinder(binder)));
        }
    };
    private static final Logger log = LoggerFactory.getLogger(NexusTypeBinder.class);
    private final Binder binder;
    private final PlexusTypeListener delegate;

    NexusTypeBinder(Binder binder, PlexusTypeListener delegate) {
        this.binder = binder;
        this.delegate = delegate;
    }

    public void hear(Class<?> implementation, Object source) {
        Class<?> role = NexusTypeBinder.getRepositoryRole(implementation);
        if (role != null) {
            String hint = NexusTypeBinder.getRepositoryHint(implementation);
            this.binder.bind(Key.get(role, (Annotation)Names.named((String)hint))).to(implementation);
            this.addRepositoryTypeDescriptor(role, hint);
        } else {
            this.delegate.hear(implementation, source);
        }
    }

    public void hear(Component component, DeferredClass<?> implementation, Object source) {
        Class<?> role = NexusTypeBinder.getRepositoryRole(implementation.load());
        if (role != null) {
            if (StringUtils.isBlank((String)component.hint())) {
                component = new ComponentImpl(component.role(), NexusTypeBinder.getRepositoryHint(implementation.load()), component.instantiationStrategy(), component.description());
            }
            this.addRepositoryTypeDescriptor(role, component.hint());
        }
        String implName = implementation.getName();
        Level level = Level.WARN;
        if (implName.startsWith("org.apache.maven.model") || implName.startsWith("org.apache.maven.index")) {
            level = Level.DEBUG;
        }
        level.log(log, "Found legacy plexus component: {}", log.isDebugEnabled() ? implementation : implName);
        this.delegate.hear(component, implementation, source);
    }

    private static Class<?> getRepositoryRole(Class<?> implementation) {
        for (Class<?> api : implementation.getInterfaces()) {
            if (!api.isAnnotationPresent(RepositoryType.class)) continue;
            return api;
        }
        return null;
    }

    private static String getRepositoryHint(Class<?> implementation) {
        String name = null;
        if (implementation.isAnnotationPresent(javax.inject.Named.class)) {
            name = implementation.getAnnotation(javax.inject.Named.class).value();
        } else if (implementation.isAnnotationPresent(Named.class)) {
            name = implementation.getAnnotation(Named.class).value();
        }
        return StringUtils.isNotBlank((String)name) ? name : implementation.getName();
    }

    private void addRepositoryTypeDescriptor(Class<? extends Repository> role, String hint) {
        RepositoryType rt = role.getAnnotation(RepositoryType.class);
        this.binder.bind(RepositoryTypeDescriptor.class).annotatedWith((Annotation)Names.named((String)(role + ":" + hint))).toInstance((Object)new RepositoryTypeDescriptor(role, hint, rt.pathPrefix(), rt.repositoryMaxInstanceCount()));
    }
}

