/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.guice;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.google.inject.servlet.ServletModule;
import com.yammer.metrics.guice.InstrumentationModule;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.shiro.guice.aop.ShiroAopModule;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.eclipse.sisu.inject.DefaultRankingFunction;
import org.eclipse.sisu.inject.RankingFunction;
import org.eclipse.sisu.wire.ParameterKeys;
import org.osgi.framework.Bundle;
import org.sonatype.nexus.guice.StaticWebResourceBundle;
import org.sonatype.nexus.web.TemplateRenderer;
import org.sonatype.nexus.web.WebResourceBundle;
import org.sonatype.nexus.web.internal.BaseUrlHolderFilter;
import org.sonatype.nexus.web.internal.CommonHeadersFilter;
import org.sonatype.nexus.web.internal.ErrorPageFilter;
import org.sonatype.nexus.web.internal.ErrorPageServlet;
import org.sonatype.security.SecuritySystem;
import org.sonatype.security.web.guice.SecurityWebModule;

public class NexusModules {

    public static class PluginModule
    extends AbstractModule {
        protected void configure() {
            this.install((Module)new CommonModule());
            this.requireBinding(SecuritySystem.class);
            this.requireBinding(FilterChainResolver.class);
            this.requireBinding(TemplateRenderer.class);
            this.bind(WebResourceBundle.class).annotatedWith((Annotation)Names.named((String)"static")).to(StaticWebResourceBundle.class).asEagerSingleton();
        }
    }

    public static class CoreModule
    extends AbstractModule {
        private final ServletContext servletContext;
        private final Map<String, String> properties;
        private final Bundle systemBundle;

        public CoreModule(ServletContext servletContext, Map<String, String> properties, Bundle systemBundle) {
            this.servletContext = (ServletContext)Preconditions.checkNotNull((Object)servletContext);
            this.properties = (Map)Preconditions.checkNotNull(properties);
            this.systemBundle = (Bundle)Preconditions.checkNotNull((Object)systemBundle);
        }

        protected void configure() {
            this.bind(ServletContext.class).annotatedWith((Annotation)Names.named((String)"nexus")).toInstance((Object)this.servletContext);
            this.bind(ParameterKeys.PROPERTIES).toInstance(this.properties);
            this.bind(Bundle.class).toInstance((Object)this.systemBundle);
            this.install((Module)new CommonModule());
            this.install((Module)new ServletModule(){

                protected void configureServlets() {
                    this.filter("/*", new String[0]).through(BaseUrlHolderFilter.class);
                    this.filter("/*", new String[0]).through(ErrorPageFilter.class);
                    this.filter("/*", new String[0]).through(CommonHeadersFilter.class);
                    this.serve("/error.html", new String[0]).with(ErrorPageServlet.class);
                    this.bind(RankingFunction.class).toInstance((Object)new DefaultRankingFunction(0x70000000));
                }
            });
            this.install((Module)new SecurityWebModule(this.servletContext, true));
        }
    }

    public static class CommonModule
    extends AbstractModule {
        protected void configure() {
            this.install((Module)new ShiroAopModule());
            this.install((Module)new InstrumentationModule());
        }
    }
}

