/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class GlobalComponentLookupHelper
extends ComponentSupport {
    private final ClassLoader classLoader;
    private final BeanLocator beanLocator;

    @Inject
    public GlobalComponentLookupHelper(@Named(value="nexus-uber") ClassLoader classLoader, BeanLocator beanLocator) {
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
    }

    @Nullable
    public Object lookup(String className) {
        Preconditions.checkNotNull((Object)className);
        try {
            this.log.trace("Looking up component: {}", (Object)className);
            Class<?> type = this.classLoader.loadClass(className);
            Iterator iter = this.beanLocator.locate(Key.get(type)).iterator();
            if (iter.hasNext()) {
                return ((BeanEntry)iter.next()).getValue();
            }
            this.log.trace("Component not found: {}", (Object)className);
        }
        catch (Exception e) {
            this.log.trace("Unable to lookup component: {}; ignoring", (Object)className, (Object)e);
        }
        return null;
    }
}

