/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.formfields;

import java.util.Arrays;
import java.util.List;
import org.sonatype.nexus.formfields.Combobox;
import org.sonatype.sisu.goodies.i18n.I18N;
import org.sonatype.sisu.goodies.i18n.MessageBundle;

public class RepositoryCombobox
extends Combobox<String> {
    public static final String REGARDLESS_VIEW_PERMISSIONS = "regardlessViewPermissions";
    public static final String FACET = "facet";
    public static final String CONTENT_CLASS = "contentClass";
    public static final String ALL_REPOS_ENTRY = "allReposEntry";
    private List<Class<?>> includingFacets;
    private List<Class<?>> excludingFacets;
    private boolean regardlessViewPermissions;
    private List<String> includingContentClasses;
    private List<String> excludingContentClasses;
    private boolean generateAllRepositoriesEntry;
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    public RepositoryCombobox(String id, String label, String helpText, boolean required, String regexValidation) {
        super(id, label, helpText, required, regexValidation);
    }

    public RepositoryCombobox(String id, String label, String helpText, boolean required) {
        super(id, label, helpText, required);
    }

    public RepositoryCombobox(String id, boolean required) {
        super(id, messages.label(), messages.helpText(), required);
    }

    public RepositoryCombobox(String id) {
        super(id, messages.label(), messages.helpText(), false);
    }

    public RepositoryCombobox includingAnyOfFacets(Class<?> ... facets) {
        this.includingFacets = Arrays.asList(facets);
        return this;
    }

    public RepositoryCombobox excludingAnyOfFacets(Class<?> ... facets) {
        this.excludingFacets = Arrays.asList(facets);
        return this;
    }

    public RepositoryCombobox includingAnyOfContentClasses(String ... contentClasses) {
        this.includingContentClasses = Arrays.asList(contentClasses);
        return this;
    }

    public RepositoryCombobox excludingAnyOfContentClasses(String ... contentClasses) {
        this.excludingContentClasses = Arrays.asList(contentClasses);
        return this;
    }

    public RepositoryCombobox regardlessViewPermissions() {
        this.regardlessViewPermissions = true;
        return this;
    }

    public RepositoryCombobox includeAnEntryForAllRepositories() {
        this.generateAllRepositoriesEntry = true;
        return this;
    }

    @Override
    public String getStorePath() {
        StringBuilder sb = new StringBuilder();
        if (this.regardlessViewPermissions) {
            sb.append(REGARDLESS_VIEW_PERMISSIONS).append("=true");
        }
        if (this.generateAllRepositoriesEntry) {
            sb.append(ALL_REPOS_ENTRY).append("=true");
        }
        if (this.includingFacets != null) {
            for (Class<?> clazz : this.includingFacets) {
                if (this.excludingFacets != null && this.excludingFacets.contains(clazz)) continue;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(FACET).append("=").append(clazz.getName());
            }
        }
        if (this.excludingFacets != null) {
            for (Class clazz : this.excludingFacets) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(FACET).append("=!").append(clazz.getName());
            }
        }
        if (this.includingContentClasses != null) {
            for (String string : this.includingContentClasses) {
                if (this.excludingContentClasses != null && this.excludingContentClasses.contains(string)) continue;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(CONTENT_CLASS).append("=").append(string);
            }
        }
        if (this.excludingContentClasses != null) {
            for (String string : this.excludingContentClasses) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(CONTENT_CLASS).append("=!").append(string);
            }
        }
        if (sb.length() > 0) {
            sb.insert(0, "?");
        }
        sb.insert(0, RepositoryCombobox.siestaStore("/capabilities/stores/repositories"));
        return sb.toString();
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Staging Profile")
        public String label();

        @MessageBundle.DefaultMessage(value="Select a staging profile")
        public String helpText();
    }
}

