/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.formfields;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.formfields.Combobox;

public class ProviderCombobox
extends Combobox<String> {
    private String name;
    private Map<String, String> params = Maps.newHashMap();

    public ProviderCombobox(String id, String label, String helpText, boolean required, String regexValidation) {
        super(id, label, helpText, required, regexValidation);
    }

    public ProviderCombobox(String id, String label, String helpText, boolean required) {
        this(id, label, helpText, required, null);
    }

    public ProviderCombobox named(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)name), (Object)"name cannot be empty");
        Preconditions.checkArgument((!name.trim().startsWith("/") ? 1 : 0) != 0, (Object)"name cannot start with '/'");
        this.name = name.trim();
        return this;
    }

    public ProviderCombobox withParam(String name, String value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)name), (Object)"name cannot be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)value), (Object)"value cannot be empty");
        this.params.put(name, value);
        return this;
    }

    @Override
    public String getStorePath() {
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"Name of store cannot be null");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (sb.length() > 0) {
            sb.insert(0, "?");
        }
        sb.insert(0, ProviderCombobox.siestaStore("/capabilities/stores/provider/" + this.name));
        return sb.toString();
    }
}

