/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.events;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.proxy.events.RepositoryConfigurationUpdatedEvent;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.tasks.ExpireCacheTask;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class RepositoryConfigurationUpdatedEventInspector
extends ComponentSupport
implements EventSubscriber,
Asynchronous {
    private final NexusScheduler nexusScheduler;

    @Inject
    public RepositoryConfigurationUpdatedEventInspector(NexusScheduler nexusScheduler) {
        this.nexusScheduler = nexusScheduler;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void inspect(RepositoryConfigurationUpdatedEvent event) {
        if (event.isLocalUrlChanged() || event.isRemoteUrlChanged()) {
            String taskName = null;
            String logMessage = null;
            if (event.isLocalUrlChanged() && event.isRemoteUrlChanged()) {
                taskName = "Local and Remote URLs changed, repositoryId=" + event.getRepository().getId() + ".";
                logMessage = "The Local and Remote URL of repository \"" + event.getRepository().getName() + "\" (id=" + event.getRepository().getId() + ") has been changed, expiring its caches.";
            } else if (!event.isLocalUrlChanged() && event.isRemoteUrlChanged()) {
                taskName = "Remote URL changed, repositoryId=" + event.getRepository().getId() + ".";
                logMessage = "The Remote URL of repository \"" + event.getRepository().getName() + "\" (id=" + event.getRepository().getId() + ") has been changed, expiring its caches.";
            } else if (event.isLocalUrlChanged() && !event.isRemoteUrlChanged()) {
                taskName = "Local URL changed, repositoryId=" + event.getRepository().getId() + ".";
                logMessage = "The Local URL of repository \"" + event.getRepository().getName() + "\" (id=" + event.getRepository().getId() + ") has been changed, expiring its caches.";
            }
            ExpireCacheTask task = this.nexusScheduler.createTaskInstance(ExpireCacheTask.class);
            task.setRepositoryId(event.getRepository().getId());
            this.nexusScheduler.submit(taskName, task);
            this.log.info(logMessage);
        }
    }
}

