/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.events;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.threads.NexusExecutorService;
import org.sonatype.nexus.threads.NexusThreadFactory;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@Singleton
public class EventSubscriberHost
extends ComponentSupport {
    private final int HOST_THREAD_POOL_SIZE = SystemPropertiesHelper.getInteger(EventSubscriberHost.class.getName() + ".poolSize", 500);
    private final EventBus eventBus;
    private final List<Provider<EventSubscriber>> eventSubscriberProviders;
    private final NexusExecutorService hostThreadPool;
    private final AsyncEventBus asyncBus;

    @Inject
    public EventSubscriberHost(EventBus eventBus, List<Provider<EventSubscriber>> eventSubscriberProviders) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.eventSubscriberProviders = (List)Preconditions.checkNotNull(eventSubscriberProviders);
        ThreadPoolExecutor target = new ThreadPoolExecutor(0, this.HOST_THREAD_POOL_SIZE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NexusThreadFactory("esh", "Event Subscriber Host"), new ThreadPoolExecutor.CallerRunsPolicy());
        this.hostThreadPool = NexusExecutorService.forCurrentSubject(target);
        this.asyncBus = new AsyncEventBus("esh-async", (Executor)((Object)this.hostThreadPool));
        eventBus.register((Object)this);
        this.log.info("Initialized");
    }

    public void startup() {
        this.log.info("Starting");
        for (Provider<EventSubscriber> eventSubscriberProvider : this.eventSubscriberProviders) {
            EventSubscriber es = null;
            try {
                es = (EventSubscriber)eventSubscriberProvider.get();
                this.register(es);
            }
            catch (Exception e) {
                this.log.warn("Could not register {}", (Object)es, (Object)e);
            }
        }
    }

    public void shutdown() {
        this.eventBus.unregister((Object)this);
        this.log.info("Stopping");
        for (Provider<EventSubscriber> eventSubscriberProvider : this.eventSubscriberProviders) {
            EventSubscriber es = null;
            try {
                es = (EventSubscriber)eventSubscriberProvider.get();
                this.unregister(es);
            }
            catch (Exception e) {
                this.log.warn("Could not unregister {}", (Object)es, (Object)e);
            }
        }
        this.hostThreadPool.shutdown();
        try {
            this.hostThreadPool.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.log.debug("Interrupted while waiting for termination", (Throwable)e);
        }
    }

    public void register(Object object) {
        if (object instanceof Asynchronous) {
            this.asyncBus.register(object);
        } else {
            this.eventBus.register(object);
        }
        this.log.trace("Registered {}", object);
    }

    public void unregister(Object object) {
        if (object instanceof Asynchronous) {
            this.asyncBus.unregister(object);
        } else {
            this.eventBus.unregister(object);
        }
        this.log.trace("Unregistered {}", object);
    }

    @VisibleForTesting
    public boolean isCalmPeriod() {
        return ((ThreadPoolExecutor)this.hostThreadPool.getTargetExecutorService()).getQueue().isEmpty() && ((ThreadPoolExecutor)this.hostThreadPool.getTargetExecutorService()).getActiveCount() == 0;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEvent(Object evt) {
        this.asyncBus.post(evt);
    }
}

