/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.events;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventPostRemove;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.tasks.DeleteRepositoryFoldersTask;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DeleteRepositoryFoldersEventInspector
extends ComponentSupport
implements EventSubscriber,
Asynchronous {
    private final boolean deletePermanently = SystemPropertiesHelper.getBoolean(DeleteRepositoryFoldersEventInspector.class.getName() + ".deletePermanently", false);
    private final NexusScheduler nexusScheduler;

    @Inject
    public DeleteRepositoryFoldersEventInspector(NexusScheduler nexusScheduler) {
        this.nexusScheduler = nexusScheduler;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void inspect(RepositoryRegistryEventPostRemove evt) {
        Repository repository = evt.getRepository();
        try {
            DeleteRepositoryFoldersTask task = this.nexusScheduler.createTaskInstance(DeleteRepositoryFoldersTask.class);
            task.setRepository(repository);
            task.setDeleteForever(this.deletePermanently);
            this.nexusScheduler.submit("Deleting repository folder for repository \"" + repository.getName() + "\" (id=" + repository.getId() + ").", task);
        }
        catch (Exception e) {
            this.log.warn("Could not remove repository folders for repository {}", (Object)repository, (Object)e);
        }
    }
}

