/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.events;

import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.ExceptionUtils;
import org.sonatype.nexus.proxy.events.Veto;
import org.sonatype.nexus.proxy.events.VetoFormatter;
import org.sonatype.nexus.proxy.events.VetoFormatterRequest;

@Named
@Singleton
public class DefaultVetoFormatter
implements VetoFormatter {
    private static final String LINE_SEPERATOR = System.getProperty("line.separator");

    @Override
    public String format(VetoFormatterRequest request) {
        StringBuilder sb = new StringBuilder();
        if (request != null && request.getEvent() != null && request.getEvent().isVetoed()) {
            sb.append("Event " + request.getEvent().toString() + " has been vetoed by one or more components.");
            if (request.isDetailed()) {
                sb.append(LINE_SEPERATOR);
                for (Veto veto : request.getEvent().getVetos()) {
                    sb.append("vetoer: " + veto.getVetoer().toString());
                    sb.append("cause:");
                    sb.append(LINE_SEPERATOR);
                    sb.append(ExceptionUtils.getFullStackTrace((Throwable)veto.getReason()));
                    sb.append(LINE_SEPERATOR);
                }
            }
        }
        return sb.toString();
    }
}

