/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.events;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.lang.management.ManagementFactory;
import javax.inject.Inject;
import javax.inject.Named;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.sisu.EagerSingleton;
import org.sonatype.nexus.events.DefaultDebugEventInspectorMBean;
import org.sonatype.nexus.events.Event;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@EagerSingleton
public class DebugEventInspector
extends ComponentSupport {
    private static final String JMX_DOMAIN = DebugEventInspector.class.getPackage().getName();
    private final boolean ENABLED_DEFAULT = SystemPropertiesHelper.getBoolean(DebugEventInspector.class.getName() + ".enabled", false);
    private volatile boolean enabled;
    private ObjectName jmxName;
    private final EventBus eventBus;

    @Inject
    public DebugEventInspector(EventBus eventBus) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        try {
            this.jmxName = ObjectName.getInstance(JMX_DOMAIN, "name", DebugEventInspector.class.getSimpleName());
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            if (server.isRegistered(this.jmxName)) {
                this.log.warn("MBean already registered; replacing: {}", (Object)this.jmxName);
                server.unregisterMBean(this.jmxName);
            }
            server.registerMBean(new DefaultDebugEventInspectorMBean(this), this.jmxName);
        }
        catch (Exception e) {
            this.jmxName = null;
            this.log.warn("Problem registering MBean for: " + ((Object)((Object)this)).getClass().getName(), (Throwable)e);
        }
        this.setEnabled(this.ENABLED_DEFAULT);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        try {
            if (enabled && !this.enabled) {
                this.eventBus.register((Object)this);
            } else if (!enabled && this.enabled) {
                this.eventBus.unregister((Object)this);
            }
        }
        finally {
            this.enabled = enabled;
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void accept(Event<?> evt) {
        this.log.info(String.valueOf(evt));
    }
}

