/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.email;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.Authenticator;
import javax.mail.Session;
import org.sonatype.micromailer.EmailerConfiguration;
import org.sonatype.nexus.email.SmtpSessionParametersCustomizer;

@Named
public class NexusEmailerConfiguration
extends EmailerConfiguration {
    private final List<SmtpSessionParametersCustomizer> customizers;

    @Inject
    public NexusEmailerConfiguration(List<SmtpSessionParametersCustomizer> customizers) {
        this.customizers = (List)Preconditions.checkNotNull(customizers);
    }

    protected Session createSession(Properties properties, Authenticator authenticator) {
        Properties params = properties;
        for (SmtpSessionParametersCustomizer customizer : this.customizers) {
            params = customizer.customize(params);
        }
        return super.createSession(params, authenticator);
    }
}

