/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.email;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.micromailer.Address;
import org.sonatype.micromailer.EMailer;
import org.sonatype.micromailer.EmailerConfiguration;
import org.sonatype.micromailer.MailRequest;
import org.sonatype.micromailer.MailRequestStatus;
import org.sonatype.nexus.configuration.model.CSmtpConfiguration;
import org.sonatype.nexus.email.EmailerException;
import org.sonatype.nexus.email.NexusEmailerConfiguration;
import org.sonatype.nexus.email.SmtpSessionParametersCustomizer;
import org.sonatype.nexus.email.SmtpSettingsValidator;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultSmtpSettingsValidator
extends ComponentSupport
implements SmtpSettingsValidator {
    private static final String NEXUS_MAIL_ID = "Nexus";
    private final EMailer emailer;
    private final List<SmtpSessionParametersCustomizer> customizers;

    @Inject
    public DefaultSmtpSettingsValidator(EMailer emailer, List<SmtpSessionParametersCustomizer> customizers) {
        this.emailer = (EMailer)Preconditions.checkNotNull((Object)emailer);
        this.customizers = (List)Preconditions.checkNotNull(customizers);
    }

    @Override
    public boolean sendSmtpConfigurationTest(CSmtpConfiguration smtp, String email) throws EmailerException {
        NexusEmailerConfiguration config = new NexusEmailerConfiguration(this.customizers);
        config.setDebug(smtp.isDebugMode());
        config.setMailHost(smtp.getHostname());
        config.setMailPort(smtp.getPort());
        config.setPassword(smtp.getPassword());
        config.setSsl(smtp.isSslEnabled());
        config.setTls(smtp.isTlsEnabled());
        config.setUsername(smtp.getUsername());
        this.emailer.configure((EmailerConfiguration)config);
        MailRequest request = new MailRequest(NEXUS_MAIL_ID, "default");
        request.setFrom(new Address(smtp.getSystemEmailAddress(), "Nexus Repository Manager"));
        request.getToAddresses().add(new Address(email));
        request.getBodyContext().put("subject", "Nexus: SMTP Configuration validation.");
        StringBuilder body = new StringBuilder();
        body.append("Your current SMTP configuration is valid!");
        request.getBodyContext().put("body", body.toString());
        MailRequestStatus status = this.emailer.sendSyncedMail(request);
        if (status.getErrorCause() != null) {
            this.log.error("Unable to send e-mail", status.getErrorCause());
            throw new EmailerException("Unable to send e-mail", status.getErrorCause());
        }
        return status.isSent();
    }
}

