/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.email;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.micromailer.Address;
import org.sonatype.micromailer.MailRequest;
import org.sonatype.nexus.email.NexusEmailer;
import org.sonatype.security.email.SecurityEmailer;

@Named
@Singleton
public class DefaultSecurityEmailer
implements SecurityEmailer {
    private final NexusEmailer nexusEmailer;

    @Inject
    public DefaultSecurityEmailer(NexusEmailer nexusEmailer) {
        this.nexusEmailer = (NexusEmailer)Preconditions.checkNotNull((Object)nexusEmailer);
    }

    public void sendNewUserCreated(String email, String userid, String password) {
        StringBuilder body = new StringBuilder();
        body.append("User Account ");
        body.append(userid);
        body.append(" has been created.  Another email will be sent shortly containing your password.");
        MailRequest request = this.nexusEmailer.getDefaultMailRequest("Nexus: New user account created.", body.toString());
        request.getToAddresses().add(new Address(email));
        this.nexusEmailer.sendMail(request);
        body = new StringBuilder();
        body.append("Your new password is ");
        body.append(password);
        request = this.nexusEmailer.getDefaultMailRequest("Nexus: New user account created.", body.toString());
        request.getToAddresses().add(new Address(email));
        this.nexusEmailer.sendMail(request);
    }

    public void sendForgotUsername(String email, List<String> userIds) {
        StringBuilder body = new StringBuilder();
        body.append("Your email is associated with the following Nexus User Id(s):\n ");
        for (String userId : userIds) {
            body.append("\n - \"");
            body.append(userId);
            body.append("\"");
        }
        MailRequest request = this.nexusEmailer.getDefaultMailRequest("Nexus: User account notification.", body.toString());
        request.getToAddresses().add(new Address(email));
        this.nexusEmailer.sendMail(request);
    }

    public void sendResetPassword(String email, String password) {
        StringBuilder body = new StringBuilder();
        body.append("Your password has been reset.  Your new password is: ");
        body.append(password);
        MailRequest request = this.nexusEmailer.getDefaultMailRequest("Nexus: User account notification.", body.toString());
        request.getToAddresses().add(new Address(email));
        this.nexusEmailer.sendMail(request);
    }
}

