/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.email;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.micromailer.Address;
import org.sonatype.micromailer.MailRequest;
import org.sonatype.nexus.email.NexusEmailer;
import org.sonatype.nexus.email.NexusPostOffice;

@Named
@Singleton
public class DefaultNexusPostOffice
implements NexusPostOffice {
    private final NexusEmailer nexusEmailer;

    @Inject
    public DefaultNexusPostOffice(NexusEmailer nexusEmailer) {
        this.nexusEmailer = (NexusEmailer)Preconditions.checkNotNull((Object)nexusEmailer);
    }

    @Override
    public void sendNexusTaskFailure(String email, String taskId, String taskName, Throwable cause) {
        StringBuilder body = new StringBuilder();
        if (taskId != null) {
            body.append(String.format("Task ID: %s", taskId)).append("\n");
        }
        if (taskName != null) {
            body.append(String.format("Task Name: %s", taskName)).append("\n");
        }
        if (cause != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            cause.printStackTrace(pw);
            body.append("Stack trace: ").append("\n").append(sw.toString());
        }
        MailRequest request = this.nexusEmailer.getDefaultMailRequest("Nexus: Task execution failure", body.toString());
        request.getToAddresses().add(new Address(email));
        this.nexusEmailer.sendMail(request);
    }
}

