/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.email;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.micromailer.Address;
import org.sonatype.micromailer.EMailer;
import org.sonatype.micromailer.EmailerConfiguration;
import org.sonatype.micromailer.MailRequest;
import org.sonatype.micromailer.MailRequestStatus;
import org.sonatype.micromailer.MailType;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.SystemStatus;
import org.sonatype.nexus.configuration.AbstractLastingConfigurable;
import org.sonatype.nexus.configuration.CoreConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.application.GlobalRestApiSettings;
import org.sonatype.nexus.configuration.model.CSmtpConfiguration;
import org.sonatype.nexus.configuration.model.CSmtpConfigurationCoreConfiguration;
import org.sonatype.nexus.email.EmailerException;
import org.sonatype.nexus.email.NexusEmailer;
import org.sonatype.nexus.email.NexusEmailerConfiguration;
import org.sonatype.nexus.email.SmtpSessionParametersCustomizer;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.sisu.goodies.common.SimpleFormat;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@Singleton
public class DefaultNexusEmailer
extends AbstractLastingConfigurable<CSmtpConfiguration>
implements NexusEmailer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNexusEmailer.class);
    private static final String NEXUS_SENDER_NAME = "Nexus Repository Manager";
    private static final String X_MESSAGE_SENDER_HEADER = "X-EMailer-Mail-Sender";
    private final GlobalRestApiSettings globalRestApiSettings;
    private final ApplicationStatusSource applicationStatusSource;
    private final EMailer eMailer;
    private final List<SmtpSessionParametersCustomizer> customizers;
    private String platformEditionShort;
    private String userAgentPlatformInfo;

    @Inject
    public DefaultNexusEmailer(EventBus eventBus, ApplicationConfiguration applicationConfiguration, GlobalRestApiSettings globalRestApiSettings, ApplicationStatusSource applicationStatusSource, EMailer eMailer, List<SmtpSessionParametersCustomizer> customizers) {
        super("SMTP Client", eventBus, applicationConfiguration);
        this.globalRestApiSettings = (GlobalRestApiSettings)Preconditions.checkNotNull((Object)globalRestApiSettings);
        this.applicationStatusSource = (ApplicationStatusSource)Preconditions.checkNotNull((Object)applicationStatusSource);
        this.eMailer = (EMailer)Preconditions.checkNotNull((Object)eMailer);
        this.customizers = (List)Preconditions.checkNotNull(customizers);
    }

    @Subscribe
    public void on(NexusStoppedEvent evt) {
        this.getEMailer().shutdown();
    }

    @Override
    public EMailer getEMailer() {
        return this.eMailer;
    }

    @Override
    public String getDefaultMailTypeId() {
        return "default";
    }

    @Override
    public MailRequest getDefaultMailRequest(String subject, String body) {
        MailRequest request = new MailRequest(this.getMailId(), this.getDefaultMailTypeId());
        request.getCustomHeaders().put(X_MESSAGE_SENDER_HEADER, this.getSenderId());
        request.setFrom(this.getSMTPSystemEmailAddress());
        request.getBodyContext().put("subject", subject);
        request.getBodyContext().put("body", body);
        return request;
    }

    @Override
    public MailRequestStatus sendMail(MailRequest request) {
        if (request.getFrom() == null) {
            request.setFrom(this.getSMTPSystemEmailAddress());
        }
        this.prependNexusBaseUrl(request);
        if (this.emailSettingsConfigured()) {
            return this.getEMailer().sendMail(request);
        }
        String message = SimpleFormat.format((String)"Mail requestId[%s] not sent, SMTP not configured", (Object[])new Object[]{request.getRequestId()});
        LOG.debug(message);
        MailRequestStatus status = new MailRequestStatus(request);
        status.setErrorCause((Throwable)new EmailerException(message));
        return status;
    }

    private void prependNexusBaseUrl(MailRequest request) {
        String baseNexusUrl = this.globalRestApiSettings.getBaseUrl();
        MailType mailType = this.getEMailer().getMailTypeSource().getMailType(request.getMailTypeId());
        StringBuilder messageBody = new StringBuilder().append("Message from: ");
        if (mailType != null && mailType.isBodyIsHtml()) {
            messageBody.append(StringUtils.isNotBlank((String)baseNexusUrl) ? String.format("<a href=\"%s\">%s</a>", baseNexusUrl, baseNexusUrl) : "<i>(Set the Base URL parameter in Nexus Server Administration to include in future emails)</i>").append("<br><br>");
        } else {
            messageBody.append(StringUtils.isNotBlank((String)baseNexusUrl) ? baseNexusUrl : "(Set the Base URL parameter in Nexus Server Administration to include in future emails)").append("\n\n");
        }
        messageBody.append(request.getBodyContext().get("body"));
        request.getBodyContext().put("body", messageBody.toString());
    }

    private boolean emailSettingsConfigured() {
        return !"smtp-host".equals(this.getSMTPHostname()) || 25 != this.getSMTPPort() || !"smtp-username".equals(this.getSMTPUsername());
    }

    @Override
    protected void initializeConfiguration() throws ConfigurationException {
        if (this.getApplicationConfiguration().getConfigurationModel() != null) {
            this.configure(this.getApplicationConfiguration());
        }
    }

    @Override
    protected CoreConfiguration<CSmtpConfiguration> wrapConfiguration(Object configuration) throws ConfigurationException {
        if (configuration instanceof ApplicationConfiguration) {
            return new CSmtpConfigurationCoreConfiguration((ApplicationConfiguration)configuration);
        }
        throw new ConfigurationException("The passed configuration object is of class \"" + configuration.getClass().getName() + "\" and not the required \"" + ApplicationConfiguration.class.getName() + "\"!");
    }

    @Override
    public void doConfigure() throws ConfigurationException {
        super.doConfigure();
        this.configureEmailer();
    }

    private synchronized void configureEmailer() {
        NexusEmailerConfiguration config = new NexusEmailerConfiguration(this.customizers);
        config.setDebug(this.isSMTPDebug());
        config.setMailHost(this.getSMTPHostname());
        config.setMailPort(this.getSMTPPort());
        config.setSsl(this.isSMTPSslEnabled());
        config.setTls(this.isSMTPTlsEnabled());
        config.setUsername(this.getSMTPUsername());
        config.setPassword(this.getSMTPPassword());
        this.getEMailer().configure((EmailerConfiguration)config);
    }

    @Override
    public String getSMTPHostname() {
        return ((CSmtpConfiguration)this.getCurrentConfiguration(false)).getHostname();
    }

    @Override
    public void setSMTPHostname(String host) {
        ((CSmtpConfiguration)this.getCurrentConfiguration(true)).setHostname(host);
    }

    @Override
    public int getSMTPPort() {
        return ((CSmtpConfiguration)this.getCurrentConfiguration(false)).getPort();
    }

    @Override
    public void setSMTPPort(int port) {
        ((CSmtpConfiguration)this.getCurrentConfiguration(true)).setPort(port);
    }

    @Override
    public String getSMTPUsername() {
        return ((CSmtpConfiguration)this.getCurrentConfiguration(false)).getUsername();
    }

    @Override
    public void setSMTPUsername(String username) {
        ((CSmtpConfiguration)this.getCurrentConfiguration(true)).setUsername(username);
    }

    @Override
    public String getSMTPPassword() {
        return ((CSmtpConfiguration)this.getCurrentConfiguration(false)).getPassword();
    }

    @Override
    public void setSMTPPassword(String password) {
        ((CSmtpConfiguration)this.getCurrentConfiguration(true)).setPassword(password);
    }

    @Override
    public Address getSMTPSystemEmailAddress() {
        return new Address(((CSmtpConfiguration)this.getCurrentConfiguration(false)).getSystemEmailAddress(), NEXUS_SENDER_NAME);
    }

    @Override
    public void setSMTPSystemEmailAddress(Address adr) {
        ((CSmtpConfiguration)this.getCurrentConfiguration(true)).setSystemEmailAddress(adr.getMailAddress());
    }

    @Override
    public boolean isSMTPDebug() {
        return ((CSmtpConfiguration)this.getCurrentConfiguration(false)).isDebugMode();
    }

    @Override
    public void setSMTPDebug(boolean val) {
        ((CSmtpConfiguration)this.getCurrentConfiguration(true)).setDebugMode(val);
    }

    @Override
    public boolean isSMTPSslEnabled() {
        return ((CSmtpConfiguration)this.getCurrentConfiguration(false)).isSslEnabled();
    }

    @Override
    public void setSMTPSslEnabled(boolean val) {
        ((CSmtpConfiguration)this.getCurrentConfiguration(true)).setSslEnabled(val);
    }

    @Override
    public boolean isSMTPTlsEnabled() {
        return ((CSmtpConfiguration)this.getCurrentConfiguration(false)).isTlsEnabled();
    }

    @Override
    public void setSMTPTlsEnabled(boolean val) {
        ((CSmtpConfiguration)this.getCurrentConfiguration(true)).setTlsEnabled(val);
    }

    protected String getMailId() {
        StringBuilder sb = new StringBuilder("NX");
        sb.append(String.valueOf(System.currentTimeMillis()));
        return sb.toString();
    }

    protected String getSenderId() {
        SystemStatus status = this.applicationStatusSource.getSystemStatus();
        if (this.platformEditionShort == null || !this.platformEditionShort.equals(status.getEditionShort()) || this.userAgentPlatformInfo == null) {
            this.platformEditionShort = status.getEditionShort();
            this.userAgentPlatformInfo = "Nexus/" + status.getVersion() + " (" + status.getEditionShort() + "; " + System.getProperty("os.name") + "; " + System.getProperty("os.version") + "; " + System.getProperty("os.arch") + "; " + System.getProperty("java.version") + ") ";
        }
        return this.userAgentPlatformInfo;
    }
}

