/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.validator;

import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationRequest;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.model.CHttpProxySettings;
import org.sonatype.nexus.configuration.model.CMirror;
import org.sonatype.nexus.configuration.model.CPathMappingItem;
import org.sonatype.nexus.configuration.model.CRemoteAuthentication;
import org.sonatype.nexus.configuration.model.CRemoteConnectionSettings;
import org.sonatype.nexus.configuration.model.CRemoteHttpProxySettings;
import org.sonatype.nexus.configuration.model.CRemoteNexusInstance;
import org.sonatype.nexus.configuration.model.CRemoteProxySettings;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryGrouping;
import org.sonatype.nexus.configuration.model.CRepositoryTarget;
import org.sonatype.nexus.configuration.model.CRestApiSettings;
import org.sonatype.nexus.configuration.model.CRouting;
import org.sonatype.nexus.configuration.model.CScheduleConfig;
import org.sonatype.nexus.configuration.model.CScheduledTask;
import org.sonatype.nexus.configuration.model.CSmtpConfiguration;
import org.sonatype.nexus.configuration.model.Configuration;
import org.sonatype.nexus.configuration.validator.ApplicationConfigurationValidator;
import org.sonatype.nexus.configuration.validator.ApplicationValidationContext;
import org.sonatype.nexus.configuration.validator.ApplicationValidationResponse;
import org.sonatype.nexus.proxy.repository.LocalStatus;

@Singleton
@Named
public class DefaultApplicationConfigurationValidator
implements ApplicationConfigurationValidator {
    private final Random rand = new Random(System.currentTimeMillis());
    public static final String REPOSITORY_ID_PATTERN = "^[a-zA-Z0-9_\\-\\.]+$";

    public String generateId() {
        return Long.toHexString(System.nanoTime() + (long)this.rand.nextInt(2008));
    }

    public ValidationResponse validateModel(ValidationRequest request) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        response.setContext(new ApplicationValidationContext());
        Configuration model = (Configuration)request.getConfiguration();
        ApplicationValidationContext context = (ApplicationValidationContext)response.getContext();
        response.setContext(context);
        if (model.getGlobalConnectionSettings() != null) {
            response.append(this.validateRemoteConnectionSettings(context, model.getGlobalConnectionSettings()));
        } else {
            model.setGlobalConnectionSettings(new CRemoteConnectionSettings());
            response.addValidationWarning("Global connection settings block, which is mandatory, was missing. Reset with defaults.");
            response.setModified(true);
        }
        CRemoteProxySettings rps = model.getRemoteProxySettings();
        if (rps != null) {
            if (rps.getHttpProxySettings() != null) {
                response.append(this.validateRemoteHttpProxySettings(context, rps.getHttpProxySettings()));
            }
            if (rps.getHttpsProxySettings() != null) {
                response.append(this.validateRemoteHttpProxySettings(context, rps.getHttpsProxySettings()));
            }
        }
        if (model.getRestApi() != null) {
            response.append(this.validateRestApiSettings(context, model.getRestApi()));
        }
        if (model.getHttpProxy() != null) {
            response.append(this.validateHttpProxySettings(context, model.getHttpProxy()));
        } else {
            model.setHttpProxy(new CHttpProxySettings());
            response.addValidationWarning("The HTTP Proxy section was missing from configuration, defaulted it.");
            response.setModified(true);
        }
        if (model.getRouting() != null) {
            response.append(this.validateRouting(context, model.getRouting()));
        } else {
            model.setRouting(new CRouting());
            response.addValidationWarning("The routing section was missing from configuration, defaulted it.");
            response.setModified(true);
        }
        context.addExistingRepositoryIds();
        List reposes = model.getRepositories();
        for (CRepository repo : reposes) {
            response.append(this.validateRepository(context, repo));
        }
        if (model.getRepositoryGrouping() != null) {
            response.append(this.validateRepositoryGrouping(context, model.getRepositoryGrouping()));
        }
        if (model.getRemoteNexusInstances() != null) {
            List instances = model.getRemoteNexusInstances();
            for (CRemoteNexusInstance instance : instances) {
                response.append(this.validateRemoteNexusInstance(context, instance));
            }
        }
        if (model.getRepositoryTargets() != null) {
            List targets = model.getRepositoryTargets();
            for (CRepositoryTarget target : targets) {
                response.append(this.validateRepositoryTarget(context, target));
            }
        }
        if (model.getTasks() != null) {
            List tasks = model.getTasks();
            for (CScheduledTask task : tasks) {
                response.append(this.validateScheduledTask(context, task));
            }
        }
        response.append(this.validateSmtpConfiguration(context, model.getSmtpConfiguration()));
        return response;
    }

    @Override
    public ValidationResponse validateRepository(ApplicationValidationContext ctx, CRepository repo) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        ApplicationValidationContext context = (ApplicationValidationContext)response.getContext();
        if (StringUtils.isEmpty((String)repo.getId())) {
            response.addValidationError(new ValidationMessage("id", "Repository ID's may not be empty!"));
        } else if (!repo.getId().matches(REPOSITORY_ID_PATTERN)) {
            response.addValidationError(new ValidationMessage("id", "Only letters, digits, underscores(_), hyphens(-), and dots(.) are allowed in Repository ID"));
        } else {
            if (StringUtils.isEmpty((String)repo.getName())) {
                repo.setName(repo.getId());
                response.addValidationWarning(new ValidationMessage("id", "Repository with ID='" + repo.getId() + "' has no name, defaulted to it's ID."));
                response.setModified(true);
            }
            if (!this.validateLocalStatus(repo.getLocalStatus())) {
                response.addValidationError(new ValidationMessage("id", "LocalStatus of repository with ID='" + repo.getId()) + "' is wrong " + repo.getLocalStatus() + "! (Allowed values are: '" + (Object)((Object)LocalStatus.IN_SERVICE) + "' and '" + (Object)((Object)LocalStatus.OUT_OF_SERVICE) + "')");
            }
            if (context.getExistingRepositoryIds() != null) {
                if (context.getExistingRepositoryIds().contains(repo.getId())) {
                    response.addValidationError(new ValidationMessage("id", "Repository with ID=" + repo.getId() + " already exists!"));
                }
                context.getExistingRepositoryIds().add(repo.getId());
            }
            if (context.getExistingRepositoryShadowIds() != null && context.getExistingRepositoryShadowIds().contains(repo.getId())) {
                response.addValidationError(new ValidationMessage("id", "Repository " + repo.getId() + " conflicts with existing Shadow with same ID='" + repo.getId() + "'!"));
            }
            if (context.getExistingRepositoryGroupIds() != null && context.getExistingRepositoryGroupIds().contains(repo.getId())) {
                response.addValidationError(new ValidationMessage("id", "Repository " + repo.getId() + " conflicts with existing Group with same ID='" + repo.getId() + "'!"));
            }
        }
        return response;
    }

    @Override
    public ValidationResponse validateRepositoryGrouping(ApplicationValidationContext ctx, CRepositoryGrouping settings) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        ApplicationValidationContext context = (ApplicationValidationContext)response.getContext();
        context.addExistingPathMappingIds();
        if (settings.getPathMappings() != null) {
            for (CPathMappingItem item : settings.getPathMappings()) {
                response.append(this.validateGroupsSettingPathMappingItem(context, item));
            }
        }
        return response;
    }

    @Override
    public ValidationResponse validateGroupsSettingPathMappingItem(ApplicationValidationContext ctx, CPathMappingItem item) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        ApplicationValidationContext context = (ApplicationValidationContext)response.getContext();
        if (StringUtils.isEmpty((String)item.getId()) || "0".equals(item.getId()) || context.getExistingPathMappingIds() != null && context.getExistingPathMappingIds().contains(item.getId())) {
            String newId = this.generateId();
            item.setId(newId);
            response.addValidationWarning("Fixed wrong route ID from '" + item.getId() + "' to '" + (String)newId + "'");
            response.setModified(true);
        }
        if (StringUtils.isEmpty((String)item.getGroupId())) {
            item.setGroupId("*");
            response.addValidationWarning("Fixed route without groupId set, set to ALL_GROUPS to keep backward comp, ID='" + item.getId() + "'.");
            response.setModified(true);
        }
        if (item.getRoutePatterns() == null || item.getRoutePatterns().isEmpty()) {
            response.addValidationError("The Route with ID='" + item.getId() + "' must contain at least one Route Pattern.");
        }
        for (String regexp : item.getRoutePatterns()) {
            if (this.isValidRegexp(regexp)) continue;
            response.addValidationError("The regexp in Route with ID='" + item.getId() + "' is not valid: " + regexp);
        }
        if (context.getExistingPathMappingIds() != null) {
            context.getExistingPathMappingIds().add(item.getId());
        }
        if (!("inclusive".equals(item.getRouteType()) || "exclusive".equals(item.getRouteType()) || "blocking".equals(item.getRouteType()))) {
            response.addValidationError("The groupMapping pattern with ID=" + item.getId() + " have invalid routeType='" + item.getRouteType() + "'. Valid route types are '" + "inclusive" + "', '" + "exclusive" + "' and '" + "blocking" + "'.");
        }
        if (context.getExistingRepositoryIds() != null && context.getExistingRepositoryShadowIds() != null) {
            List<String> existingReposes = context.getExistingRepositoryIds();
            List<String> existingShadows = context.getExistingRepositoryShadowIds();
            for (String repoId : item.getRepositories()) {
                if (existingReposes.contains(repoId) || existingShadows.contains(repoId)) continue;
                response.addValidationError("The groupMapping pattern with ID=" + item.getId() + " refers to a nonexistent repository with repoID = " + repoId);
            }
        }
        return response;
    }

    @Override
    public ValidationResponse validateHttpProxySettings(ApplicationValidationContext ctx, CHttpProxySettings settings) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        if (settings.getPort() < 80) {
            settings.setPort(8082);
            response.addValidationWarning("The HTTP Proxy port is below 80? Settings defaulted.");
            response.setModified(true);
        }
        if (!"passThru".equals(settings.getProxyPolicy()) && !"strict".equals(settings.getProxyPolicy())) {
            response.addValidationError("The HTTP Proxy policy settings is invalid: '" + settings.getProxyPolicy() + "'. Valid policies are '" + "strict" + "' and '" + "passThru" + "'.");
        }
        return response;
    }

    @Override
    public ValidationResponse validateRemoteAuthentication(ApplicationValidationContext ctx, CRemoteAuthentication settings) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        return response;
    }

    @Override
    public ValidationResponse validateRemoteConnectionSettings(ApplicationValidationContext ctx, CRemoteConnectionSettings settings) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        return response;
    }

    @Override
    public ValidationResponse validateRemoteHttpProxySettings(ApplicationValidationContext ctx, CRemoteHttpProxySettings settings) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        if (settings.getProxyPort() < 1 || settings.getProxyPort() > 65535) {
            response.addValidationError("The proxy port must be an integer between 1 and 65535!");
        }
        response.append(this.validateRemoteAuthentication(ctx, settings.getAuthentication()));
        return response;
    }

    @Override
    public ValidationResponse validateRepositoryMirrors(ApplicationValidationContext ctx, List<CMirror> mirrors) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        for (CMirror mirror : mirrors) {
            if (StringUtils.isEmpty((String)mirror.getId())) {
                String newId = this.generateId();
                mirror.setId(newId);
                response.addValidationWarning("Fixed wrong mirror ID from '" + mirror.getId() + "' to '" + newId + "'");
                response.setModified(true);
            }
            if (StringUtils.isEmpty((String)mirror.getId())) {
                response.addValidationError("The Mirror may have no empty/null ID!");
            }
            if (!StringUtils.isEmpty((String)mirror.getUrl())) continue;
            response.addValidationError("The Mirror may have no empty/null URL!");
        }
        return response;
    }

    @Override
    public ValidationResponse validateRepositoryTarget(ApplicationValidationContext ctx, CRepositoryTarget settings) {
        List patterns;
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        ApplicationValidationContext context = (ApplicationValidationContext)response.getContext();
        if (StringUtils.isEmpty((String)settings.getId())) {
            response.addValidationError("The RepositoryTarget may have no empty/null ID!");
        }
        if (StringUtils.isEmpty((String)settings.getName())) {
            response.addValidationError("The RepositoryTarget may have no empty/null Name!");
        }
        if (StringUtils.isEmpty((String)settings.getContentClass())) {
            response.addValidationError("Repository target with ID='" + settings.getId() + "' has empty content class!");
        }
        if (context.getExistingRepositoryTargetIds() != null) {
            for (String id : context.getExistingRepositoryTargetIds()) {
                if (!id.equals(settings.getId())) continue;
                response.addValidationError("This target ID is already existing!");
            }
        }
        if ((patterns = settings.getPatterns()) != null && patterns.size() > 0) {
            for (String pattern : patterns) {
                if (this.isValidRegexp(pattern)) continue;
                response.addValidationError("Repository target with ID='" + settings.getId() + "' has invalid regexp pattern: " + pattern);
            }
        } else {
            response.addValidationError("Repository target with ID='" + settings.getId() + "' has no regexp pattern defined!");
        }
        return response;
    }

    @Override
    public ValidationResponse validateRestApiSettings(ApplicationValidationContext ctx, CRestApiSettings settings) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        return response;
    }

    @Override
    public ValidationResponse validateRouting(ApplicationValidationContext ctx, CRouting settings) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        return response;
    }

    @Override
    public ValidationResponse validateRemoteNexusInstance(ApplicationValidationContext ctx, CRemoteNexusInstance settings) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        return response;
    }

    @Override
    public ValidationResponse validateScheduledTask(ApplicationValidationContext ctx, CScheduledTask settings) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        ApplicationValidationContext context = (ApplicationValidationContext)response.getContext();
        response.append(this.validateSchedule(context, settings.getSchedule()));
        return response;
    }

    @Override
    public ValidationResponse validateSchedule(ApplicationValidationContext ctx, CScheduleConfig settings) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        return response;
    }

    @Override
    public ValidationResponse validateSmtpConfiguration(ApplicationValidationContext ctx, CSmtpConfiguration settings) {
        ValidationMessage msg;
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        if (StringUtils.isEmpty((String)settings.getHostname())) {
            msg = new ValidationMessage("host", "SMTP Host is empty.");
            response.addValidationError(msg);
        }
        if (settings.getPort() < 0) {
            msg = new ValidationMessage("port", "SMTP Port is inavlid.  Enter a port greater than 0.");
            response.addValidationError(msg);
        }
        if (StringUtils.isEmpty((String)settings.getSystemEmailAddress())) {
            msg = new ValidationMessage("systemEmailAddress", "System Email Address is empty.");
            response.addValidationError(msg);
        }
        return response;
    }

    protected boolean validateLocalStatus(String ls) {
        return LocalStatus.IN_SERVICE.name().equals(ls) || LocalStatus.OUT_OF_SERVICE.name().equals(ls);
    }

    protected boolean isValidRegexp(String regexp) {
        if (regexp == null) {
            return false;
        }
        try {
            Pattern.compile(regexp);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }
}

