/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.source;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.model.Configuration;
import org.sonatype.nexus.configuration.source.AbstractApplicationConfigurationSource;
import org.sonatype.nexus.util.ApplicationInterpolatorProvider;

@Singleton
@Named(value="static")
public class StaticConfigurationSource
extends AbstractApplicationConfigurationSource {
    @Inject
    public StaticConfigurationSource(ApplicationInterpolatorProvider interpolatorProvider) {
        super(interpolatorProvider);
    }

    public InputStream getConfigurationAsStream() throws IOException {
        InputStream result = this.getClass().getResourceAsStream("/META-INF/nexus/nexus.xml");
        if (result != null) {
            return result;
        }
        this.log.info("No edition-specific configuration found, falling back to Core default configuration.");
        return this.getClass().getResourceAsStream("/META-INF/nexus/default-oss-nexus.xml");
    }

    public Configuration loadConfiguration() throws ConfigurationException, IOException {
        this.loadConfiguration(this.getConfigurationAsStream());
        return this.getConfiguration();
    }

    public void storeConfiguration() throws IOException {
        throw new UnsupportedOperationException("The NexusDefaultsConfigurationSource is static source!");
    }

    public boolean isConfigurationDefaulted() {
        return false;
    }

    @Override
    public void backupConfiguration() throws IOException {
        throw new UnsupportedOperationException("The NexusDefaultsConfigurationSource is static source!");
    }
}

