/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.source;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.Configuration;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationRequest;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.configuration.application.upgrade.ApplicationConfigurationUpgrader;
import org.sonatype.nexus.configuration.model.ConfigurationHelper;
import org.sonatype.nexus.configuration.model.io.xpp3.NexusConfigurationXpp3Writer;
import org.sonatype.nexus.configuration.source.AbstractApplicationConfigurationSource;
import org.sonatype.nexus.configuration.source.ApplicationConfigurationSource;
import org.sonatype.nexus.configuration.validator.ApplicationConfigurationValidator;
import org.sonatype.nexus.configuration.validator.ConfigurationValidator;
import org.sonatype.nexus.util.ApplicationInterpolatorProvider;
import org.sonatype.nexus.util.file.DirSupport;
import org.sonatype.security.events.SecurityConfigurationChanged;
import org.sonatype.sisu.goodies.common.io.FileReplacer;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named(value="file")
public class FileConfigurationSource
extends AbstractApplicationConfigurationSource {
    private final EventBus eventBus;
    private final ApplicationStatusSource applicationStatusSource;
    private final File configurationFile;
    private final ApplicationConfigurationValidator configurationValidator;
    private final ApplicationConfigurationUpgrader configurationUpgrader;
    private final ApplicationConfigurationSource nexusDefaults;
    private final ConfigurationHelper configHelper;
    private boolean configurationDefaulted;

    @Inject
    public FileConfigurationSource(ApplicationInterpolatorProvider interpolatorProvider, EventBus eventBus, ApplicationStatusSource applicationStatusSource, @Named(value="${nexus-work}/conf/nexus.xml") File configurationFile, ApplicationConfigurationValidator configurationValidator, ApplicationConfigurationUpgrader configurationUpgrader, @Named(value="static") ApplicationConfigurationSource nexusDefaults, ConfigurationHelper configHelper) {
        super(interpolatorProvider);
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.applicationStatusSource = (ApplicationStatusSource)Preconditions.checkNotNull((Object)applicationStatusSource);
        this.configurationFile = (File)Preconditions.checkNotNull((Object)configurationFile);
        this.configurationValidator = (ApplicationConfigurationValidator)Preconditions.checkNotNull((Object)configurationValidator);
        this.configurationUpgrader = (ApplicationConfigurationUpgrader)Preconditions.checkNotNull((Object)configurationUpgrader);
        this.nexusDefaults = (ApplicationConfigurationSource)Preconditions.checkNotNull((Object)nexusDefaults);
        this.configHelper = (ConfigurationHelper)Preconditions.checkNotNull((Object)configHelper);
    }

    public ConfigurationValidator getConfigurationValidator() {
        return this.configurationValidator;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public org.sonatype.nexus.configuration.model.Configuration loadConfiguration() throws ConfigurationException, IOException {
        this.nexusDefaults.loadConfiguration();
        if (this.getConfigurationFile() == null || this.getConfigurationFile().getAbsolutePath().contains("${")) {
            throw new ConfigurationException("The configuration file is not set or resolved properly: " + this.getConfigurationFile().getAbsolutePath());
        }
        if (!this.getConfigurationFile().exists()) {
            this.log.warn("No configuration file in place, copying the default one and continuing with it.");
            this.setConfiguration((org.sonatype.nexus.configuration.model.Configuration)this.nexusDefaults.getConfiguration());
            this.saveConfiguration(this.getConfigurationFile());
            this.configurationDefaulted = true;
        } else {
            this.configurationDefaulted = false;
        }
        try {
            this.loadConfiguration(this.getConfigurationFile());
            this.setConfigurationUpgraded(false);
        }
        catch (ConfigurationException e) {
            this.log.info("Configuration file is outdated, begin upgrade");
            this.upgradeConfiguration(this.getConfigurationFile());
            this.setConfigurationUpgraded(true);
            this.loadConfiguration(this.getConfigurationFile());
            this.eventBus.post((Object)new SecurityConfigurationChanged());
        }
        this.upgradeNexusVersion();
        ValidationResponse vResponse = this.getConfigurationValidator().validateModel(new ValidationRequest((Configuration)this.getConfiguration()));
        this.dumpValidationErrors(vResponse);
        this.setValidationResponse(vResponse);
        if (vResponse.isValid()) {
            if (vResponse.isModified()) {
                this.log.info("Validation has modified the configuration, storing the changes.");
                this.storeConfiguration();
            }
            return this.getConfiguration();
        }
        throw new InvalidConfigurationException(vResponse);
    }

    protected void dumpValidationErrors(ValidationResponse response) {
        if (response.getValidationErrors().size() > 0 || response.getValidationWarnings().size() > 0) {
            this.log.error("* * * * * * * * * * * * * * * * * * * * * * * * * *");
            this.log.error("Nexus configuration has validation errors/warnings");
            this.log.error("* * * * * * * * * * * * * * * * * * * * * * * * * *");
            if (response.getValidationErrors().size() > 0) {
                this.log.error("The ERRORS:");
                for (ValidationMessage msg : response.getValidationErrors()) {
                    this.log.error(msg.toString());
                }
            }
            if (response.getValidationWarnings().size() > 0) {
                this.log.error("The WARNINGS:");
                for (ValidationMessage msg : response.getValidationWarnings()) {
                    this.log.error(msg.toString());
                }
            }
            this.log.error("* * * * * * * * * * * * * * * * * * * * *");
        } else {
            this.log.info("Nexus configuration validated successfully.");
        }
    }

    protected void upgradeNexusVersion() throws IOException {
        String previousVersion;
        String currentVersion = (String)Preconditions.checkNotNull((Object)this.applicationStatusSource.getSystemStatus().getVersion());
        if (currentVersion.equals(previousVersion = this.getConfiguration().getNexusVersion())) {
            this.setInstanceUpgraded(false);
        } else {
            this.setInstanceUpgraded(true);
            this.getConfiguration().setNexusVersion(currentVersion);
            this.storeConfiguration();
        }
    }

    public void storeConfiguration() throws IOException {
        this.saveConfiguration(this.getConfigurationFile());
    }

    public InputStream getConfigurationAsStream() throws IOException {
        return new FileInputStream(this.getConfigurationFile());
    }

    @Override
    public ApplicationConfigurationSource getDefaultsSource() {
        return this.nexusDefaults;
    }

    protected void upgradeConfiguration(File file) throws IOException, ConfigurationException {
        this.log.info("Trying to upgrade the configuration file " + file.getAbsolutePath());
        this.setConfiguration(this.configurationUpgrader.loadOldConfiguration(file));
        if (this.getConfiguration() == null) {
            throw new ConfigurationException("Could not upgrade Nexus configuration! Please replace the " + file.getAbsolutePath() + " file with a valid Nexus configuration file.");
        }
        this.log.info("Creating backup from the old file and saving the upgraded configuration.");
        this.backupConfiguration();
        this.saveConfiguration(file);
    }

    private void loadConfiguration(File file) throws IOException, ConfigurationException {
        this.log.debug("Loading Nexus configuration from " + file.getAbsolutePath());
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            this.loadConfiguration(fis);
            if (this.getConfiguration() != null) {
                this.setConfiguration(this.configHelper.encryptDecryptPasswords(this.getConfiguration(), false));
            }
        }
    }

    private void saveConfiguration(File file) throws IOException {
        try {
            DirSupport.mkdir(file.getParentFile().toPath());
        }
        catch (IOException e) {
            String message = "\r\n******************************************************************************\r\n* Could not create configuration file [ " + file.toString() + "]!!!! *\r\n" + "* Nexus cannot start properly until the process has read+write permissions to this folder *\r\n" + "******************************************************************************";
            this.log.error(message, (Throwable)e);
            throw new IOException("Could not create configuration file " + file.getAbsolutePath(), e);
        }
        final org.sonatype.nexus.configuration.model.Configuration configuration = this.configHelper.encryptDecryptPasswords(this.getConfiguration(), true);
        this.log.debug("Saving configuration: {}", (Object)file);
        FileReplacer fileReplacer = new FileReplacer(file);
        fileReplacer.setDeleteBackupFile(true);
        fileReplacer.replace(new FileReplacer.ContentWriter(){

            public void write(BufferedOutputStream output) throws IOException {
                new NexusConfigurationXpp3Writer().write((OutputStream)output, configuration);
            }
        });
    }

    public boolean isConfigurationDefaulted() {
        return this.configurationDefaulted;
    }

    @Override
    public void backupConfiguration() throws IOException {
        File file = this.getConfigurationFile();
        File backup = new File(file.getParentFile(), file.getName() + ".bak");
        Files.copy(file.toPath(), backup.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }
}

