/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.source;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.codehaus.plexus.interpolation.InterpolatorFilterReader;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.model.Configuration;
import org.sonatype.nexus.configuration.model.io.xpp3.NexusConfigurationXpp3Reader;
import org.sonatype.nexus.configuration.source.AbstractConfigurationSource;
import org.sonatype.nexus.configuration.source.ApplicationConfigurationSource;
import org.sonatype.nexus.util.ApplicationInterpolatorProvider;

public abstract class AbstractApplicationConfigurationSource
extends AbstractConfigurationSource
implements ApplicationConfigurationSource {
    private final ApplicationInterpolatorProvider interpolatorProvider;
    private Configuration configuration;
    private boolean instanceUpgraded;

    public AbstractApplicationConfigurationSource(ApplicationInterpolatorProvider interpolatorProvider) {
        this.interpolatorProvider = (ApplicationInterpolatorProvider)Preconditions.checkNotNull((Object)interpolatorProvider);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected void rejectConfiguration(String message, Throwable e) {
        this.configuration = null;
        if (message != null) {
            this.log.debug(message, e);
        }
    }

    protected void loadConfiguration(InputStream is) throws IOException, ConfigurationException {
        try (Reader fr = null;){
            NexusConfigurationXpp3Reader reader = new NexusConfigurationXpp3Reader();
            fr = new InputStreamReader(is);
            InterpolatorFilterReader ip = new InterpolatorFilterReader(fr, this.interpolatorProvider.getInterpolator());
            this.configuration = reader.read((Reader)ip);
        }
        if (this.configuration != null && !"2.8.0".equals(this.configuration.getVersion())) {
            String message = "Nexus configuration file was loaded but discarded, it has the wrong version number." + " (expected 2.8.0, actual " + this.configuration.getVersion() + ")";
            this.rejectConfiguration(message, null);
            throw new ConfigurationException(message);
        }
        if (this.getConfiguration() != null) {
            this.log.info("Configuration loaded successfully.");
        }
    }

    @Override
    public ApplicationConfigurationSource getDefaultsSource() {
        return null;
    }

    @Override
    public boolean isInstanceUpgraded() {
        return this.instanceUpgraded;
    }

    public void setInstanceUpgraded(boolean instanceUpgraded) {
        this.instanceUpgraded = instanceUpgraded;
    }
}

