/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.security.upgrade;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.SystemStatus;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.proxy.events.NexusStartedEvent;
import org.sonatype.security.configuration.SecurityConfigurationManager;
import org.sonatype.security.events.SecurityConfigurationChanged;
import org.sonatype.security.model.CUser;
import org.sonatype.security.model.Configuration;
import org.sonatype.security.model.source.SecurityModelConfigurationSource;
import org.sonatype.security.model.upgrade.SecurityDataUpgrader;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named(value="SecurityUpgradeEventInspector")
public class SecurityUpgradeEventInspector
extends ComponentSupport
implements EventSubscriber {
    private final EventBus eventBus;
    private final ApplicationStatusSource applicationStatusSource;
    private final SecurityModelConfigurationSource realmConfigSource;
    private final SecurityConfigurationManager systemConfigManager;
    private SecurityDataUpgrader upgrader;

    @Inject
    public SecurityUpgradeEventInspector(EventBus eventBus, ApplicationStatusSource applicationStatusSource, @Named(value="file") SecurityModelConfigurationSource realmConfigSource, SecurityConfigurationManager systemConfigManager, @Named(value="2.0.1") SecurityDataUpgrader upgrader) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.applicationStatusSource = (ApplicationStatusSource)Preconditions.checkNotNull((Object)applicationStatusSource);
        this.realmConfigSource = (SecurityModelConfigurationSource)Preconditions.checkNotNull((Object)realmConfigSource);
        this.systemConfigManager = (SecurityConfigurationManager)Preconditions.checkNotNull((Object)systemConfigManager);
        this.upgrader = (SecurityDataUpgrader)Preconditions.checkNotNull((Object)upgrader);
    }

    @Subscribe
    public void inspect(NexusStartedEvent startedEvent) {
        SystemStatus systemStatus = this.applicationStatusSource.getSystemStatus();
        if (systemStatus.isConfigurationUpgraded() || systemStatus.isInstanceUpgraded()) {
            try {
                this.realmConfigSource.loadConfiguration();
                boolean changed = false;
                Configuration securityRealmConfig = (Configuration)this.realmConfigSource.getConfiguration();
                if (securityRealmConfig.getVersion().equals("2.0.2")) {
                    this.upgrader.upgrade((Object)this.realmConfigSource.getConfiguration());
                    changed = true;
                }
                if (!this.systemConfigManager.isAnonymousAccessEnabled() && !StringUtils.isBlank((String)this.systemConfigManager.getAnonymousUsername())) {
                    securityRealmConfig = (Configuration)this.realmConfigSource.getConfiguration();
                    for (CUser user : securityRealmConfig.getUsers()) {
                        if (!StringUtils.equals((String)this.systemConfigManager.getAnonymousUsername(), (String)user.getId())) continue;
                        user.setStatus("disabled");
                        changed = true;
                        break;
                    }
                }
                if (changed) {
                    this.realmConfigSource.storeConfiguration();
                    this.eventBus.post((Object)new SecurityConfigurationChanged());
                }
            }
            catch (ConfigurationIsCorruptedException e) {
                this.log.error("Failed to upgrade security.xml: " + (Object)((Object)e));
                startedEvent.putVeto(this, e);
            }
            catch (ConfigurationException e) {
                this.log.error("Failed to upgrade security.xml: " + (Object)((Object)e));
                startedEvent.putVeto(this, e);
            }
            catch (IOException e) {
                this.log.error("Failed to upgrade security.xml: " + e);
                startedEvent.putVeto(this, e);
            }
        }
    }
}

