/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.security.upgrade;

import java.util.Arrays;
import java.util.List;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.security.model.CRole;
import org.sonatype.security.model.CUserRoleMapping;
import org.sonatype.security.model.Configuration;
import org.sonatype.security.model.upgrade.AbstractDataUpgrader;
import org.sonatype.security.model.upgrade.SecurityDataUpgrader;

@Singleton
@Typed(value={SecurityDataUpgrader.class})
@Named(value="2.0.4")
public class SecurityData204Upgrade
extends AbstractDataUpgrader<Configuration>
implements SecurityDataUpgrader {
    private static final List<String> DEPRECATED_ROLES = Arrays.asList("admin", "deployment", "developer");

    public void doUpgrade(Configuration cfg) throws ConfigurationIsCorruptedException {
        for (CRole role : cfg.getRoles()) {
            SecurityData204Upgrade.updateDeprecatedRoles(role.getRoles());
        }
        for (CUserRoleMapping map : cfg.getUserRoleMappings()) {
            SecurityData204Upgrade.updateDeprecatedRoles(map.getRoles());
        }
    }

    public static void updateDeprecatedRoles(List<String> roles) {
        for (int i = 0; i < roles.size(); ++i) {
            String role = roles.get(i);
            if (!DEPRECATED_ROLES.contains(role)) continue;
            roles.set(i, "nx-" + role);
        }
    }
}

