/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.security.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.security.model.upgrade.AbstractDataUpgrader;
import org.sonatype.security.model.upgrade.SecurityDataUpgrader;
import org.sonatype.security.model.v2_0_2.CPrivilege;
import org.sonatype.security.model.v2_0_2.CProperty;
import org.sonatype.security.model.v2_0_2.CRole;
import org.sonatype.security.model.v2_0_2.Configuration;
import org.sonatype.security.model.v2_0_2.io.xpp3.SecurityConfigurationXpp3Reader;

@Singleton
@Typed(value={SecurityDataUpgrader.class})
@Named(value="2.0.1")
public class SecurityData201Upgrade
extends AbstractDataUpgrader<Configuration>
implements SecurityDataUpgrader {
    private static final Logger logger = LoggerFactory.getLogger(SecurityData201Upgrade.class);

    public void doUpgrade(Configuration configuration) throws ConfigurationIsCorruptedException {
        Map<String, CPrivilege> privilegeMap = this.getStaticPrivilages();
        for (CPrivilege privilege : configuration.getPrivileges()) {
            if (!"target".equals(privilege.getType())) continue;
            privilegeMap.put(privilege.getId(), privilege);
        }
        for (CRole role : configuration.getRoles()) {
            HashSet<String> repositories = new HashSet<String>();
            List privilegeIds = role.getPrivileges();
            for (String privilegeId : privilegeIds) {
                CPrivilege privilege = privilegeMap.get(privilegeId);
                if (privilege != null) {
                    repositories.addAll(this.getRepositoriesFromTargetPrivilege(privilege));
                    continue;
                }
                logger.warn("Failed to find privilege '" + privilegeId + "', but it was under the role '" + role.getId() + "'.");
            }
            if (repositories.contains("all")) {
                this.addViewPermissionToRole(role, privilegeIds, "all");
                continue;
            }
            for (String repoId : repositories) {
                this.addViewPermissionToRole(role, privilegeIds, repoId);
            }
        }
    }

    private void addViewPermissionToRole(CRole role, List<String> existingPrivilegeIds, String repositoryId) {
        String permission = "repository-" + repositoryId;
        if (!existingPrivilegeIds.contains(permission)) {
            role.addPrivilege(permission);
        }
    }

    private Set<String> getRepositoriesFromTargetPrivilege(CPrivilege privilege) {
        HashSet<String> repositories = new HashSet<String>();
        for (CProperty property : privilege.getProperties()) {
            if (!"repositoryId".equals(property.getKey()) && !"repositoryGroupId".equals(property.getKey()) || !StringUtils.isNotEmpty((String)property.getValue())) continue;
            repositories.add(property.getValue());
        }
        if (repositories.isEmpty()) {
            repositories.add("all");
        }
        return repositories;
    }

    private Map<String, CPrivilege> getStaticPrivilages() {
        String staticSecurityPath = "/META-INF/nexus/static-security.xml";
        HashMap<String, CPrivilege> privilegeMap = new HashMap<String, CPrivilege>();
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(staticSecurityPath);
             InputStreamReader fr = new InputStreamReader(is);){
            SecurityConfigurationXpp3Reader reader = new SecurityConfigurationXpp3Reader();
            Configuration staticConfig = reader.read((Reader)fr);
            for (CPrivilege privilege : staticConfig.getPrivileges()) {
                if (!"target".equals(privilege.getType())) continue;
                privilegeMap.put(privilege.getId(), privilege);
            }
        }
        catch (IOException e) {
            logger.error("IOException while retrieving configuration file", (Throwable)e);
        }
        catch (XmlPullParserException e) {
            logger.error("Invalid XML Configuration", (Throwable)e);
        }
        return privilegeMap;
    }
}

