/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.model;

import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.CoreConfiguration;
import org.sonatype.nexus.configuration.ExternalConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.AbstractXpp3DomExternalConfigurationHolder;

public class DefaultExternalConfiguration<T extends AbstractXpp3DomExternalConfigurationHolder>
implements ExternalConfiguration<T> {
    private final ApplicationConfiguration applicationConfiguration;
    private final CoreConfiguration coreConfiguration;
    private final T configuration;
    private T changedConfiguration;

    public DefaultExternalConfiguration(ApplicationConfiguration applicationConfiguration, CoreConfiguration coreConfiguration, T configuration) {
        this.applicationConfiguration = applicationConfiguration;
        this.coreConfiguration = coreConfiguration;
        this.configuration = configuration;
        this.changedConfiguration = null;
    }

    public boolean isDirty() {
        return this.changedConfiguration != null;
    }

    public void validateChanges() throws ConfigurationException {
        if (this.changedConfiguration != null) {
            ((AbstractXpp3DomExternalConfigurationHolder)this.changedConfiguration).validate(this.getApplicationConfiguration(), this.coreConfiguration);
        }
    }

    public void commitChanges() throws ConfigurationException {
        if (this.changedConfiguration != null) {
            ((AbstractXpp3DomExternalConfigurationHolder)this.changedConfiguration).validate(this.getApplicationConfiguration(), this.coreConfiguration);
            ((AbstractXpp3DomExternalConfigurationHolder)this.configuration).apply((AbstractXpp3DomExternalConfigurationHolder)this.changedConfiguration);
            this.changedConfiguration = null;
        }
    }

    public void rollbackChanges() {
        this.changedConfiguration = null;
    }

    public T getConfiguration(boolean forModification) {
        if (forModification) {
            if (this.changedConfiguration == null) {
                this.changedConfiguration = (AbstractXpp3DomExternalConfigurationHolder)((AbstractXpp3DomExternalConfigurationHolder)this.configuration).clone();
            }
            return this.changedConfiguration;
        }
        return this.configuration;
    }

    protected ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }
}

