/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.model;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.configuration.PasswordHelper;
import org.sonatype.nexus.configuration.model.CRemoteAuthentication;
import org.sonatype.nexus.configuration.model.CRemoteProxySettings;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CSmtpConfiguration;
import org.sonatype.nexus.configuration.model.Configuration;
import org.sonatype.nexus.configuration.model.ConfigurationHelper;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class DefaultConfigurationHelper
extends ComponentSupport
implements ConfigurationHelper {
    private final PasswordHelper passwordHelper;
    private static final String PASSWORD_MASK = "*****";
    private static XStream xstream = new XStream();

    @Inject
    public DefaultConfigurationHelper(PasswordHelper passwordHelper) {
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
    }

    @Override
    public Configuration encryptDecryptPasswords(Configuration config, boolean encrypt) {
        if (null == config) {
            return null;
        }
        Configuration copy = this.clone(config);
        this.handlePasswords(copy, encrypt, false);
        return copy;
    }

    protected Configuration clone(Configuration config) {
        return (Configuration)xstream.fromXML(xstream.toXML((Object)config));
    }

    protected void handlePasswords(Configuration config, boolean encrypt, boolean mask) {
        CRemoteProxySettings rps;
        if (config.getSmtpConfiguration() != null && StringUtils.isNotEmpty((String)config.getSmtpConfiguration().getPassword())) {
            CSmtpConfiguration smtpConfig = config.getSmtpConfiguration();
            smtpConfig.setPassword(this.encryptDecryptPassword(smtpConfig.getPassword(), encrypt, mask));
        }
        if ((rps = config.getRemoteProxySettings()) != null) {
            CRemoteAuthentication auth;
            if (rps.getHttpProxySettings() != null && rps.getHttpProxySettings().getAuthentication() != null && StringUtils.isNotEmpty((String)rps.getHttpProxySettings().getAuthentication().getPassword())) {
                auth = rps.getHttpProxySettings().getAuthentication();
                auth.setPassword(this.encryptDecryptPassword(auth.getPassword(), encrypt, mask));
            }
            if (rps.getHttpsProxySettings() != null && rps.getHttpsProxySettings().getAuthentication() != null && StringUtils.isNotEmpty((String)rps.getHttpsProxySettings().getAuthentication().getPassword())) {
                auth = rps.getHttpsProxySettings().getAuthentication();
                auth.setPassword(this.encryptDecryptPassword(auth.getPassword(), encrypt, mask));
            }
        }
        for (CRepository repo : config.getRepositories()) {
            if (repo.getRemoteStorage() == null || repo.getRemoteStorage().getAuthentication() == null || !StringUtils.isNotEmpty((String)repo.getRemoteStorage().getAuthentication().getPassword())) continue;
            CRemoteAuthentication auth = repo.getRemoteStorage().getAuthentication();
            auth.setPassword(this.encryptDecryptPassword(auth.getPassword(), encrypt, mask));
        }
    }

    protected String encryptDecryptPassword(String password, boolean encrypt, boolean mask) {
        if (mask) {
            return PASSWORD_MASK;
        }
        if (encrypt) {
            try {
                return this.passwordHelper.encrypt(password);
            }
            catch (PlexusCipherException e) {
                this.log.error("Failed to encrypt password in nexus.xml.", (Throwable)e);
            }
        } else {
            try {
                return this.passwordHelper.decrypt(password);
            }
            catch (PlexusCipherException e) {
                this.log.error("Failed to decrypt password in nexus.xml.", (Throwable)e);
            }
        }
        return password;
    }
}

