/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.model;

import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.AbstractCoreConfiguration;
import org.sonatype.nexus.configuration.model.CPathMappingItem;
import org.sonatype.nexus.configuration.model.CRepositoryGrouping;
import org.sonatype.nexus.configuration.model.Configuration;
import org.sonatype.nexus.configuration.validator.ApplicationValidationContext;
import org.sonatype.nexus.configuration.validator.ApplicationValidationResponse;

public class CRepositoryGroupingCoreConfiguration
extends AbstractCoreConfiguration<CRepositoryGrouping> {
    private Random rand = new Random(System.currentTimeMillis());

    public CRepositoryGroupingCoreConfiguration(ApplicationConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected CRepositoryGrouping extractConfiguration(Configuration configuration) {
        return configuration.getRepositoryGrouping();
    }

    @Override
    public ValidationResponse doValidateChanges(CRepositoryGrouping changedConfiguration) {
        CRepositoryGrouping settings = changedConfiguration;
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        ApplicationValidationContext context = (ApplicationValidationContext)response.getContext();
        context.addExistingPathMappingIds();
        if (settings.getPathMappings() != null) {
            for (CPathMappingItem item : settings.getPathMappings()) {
                response.append(this.validateGroupsSettingPathMappingItem(context, item));
            }
        }
        return response;
    }

    public String generateId() {
        return Long.toHexString(System.nanoTime() + (long)this.rand.nextInt(2008));
    }

    protected boolean isValidRegexp(String regexp) {
        if (regexp == null) {
            return false;
        }
        try {
            Pattern.compile(regexp);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    public ValidationResponse validateGroupsSettingPathMappingItem(ApplicationValidationContext ctx, CPathMappingItem item) {
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (ctx != null) {
            response.setContext(ctx);
        }
        ApplicationValidationContext context = (ApplicationValidationContext)response.getContext();
        if (StringUtils.isEmpty((String)item.getId()) || "0".equals(item.getId()) || context.getExistingPathMappingIds() != null && context.getExistingPathMappingIds().contains(item.getId())) {
            String newId = this.generateId();
            item.setId(newId);
            response.addValidationWarning("Fixed wrong route ID from '" + item.getId() + "' to '" + (String)newId + "'");
            response.setModified(true);
        }
        if (StringUtils.isEmpty((String)item.getGroupId())) {
            item.setGroupId("*");
            response.addValidationWarning("Fixed route without groupId set, set to ALL_GROUPS to keep backward comp, ID='" + item.getId() + "'.");
            response.setModified(true);
        }
        if (item.getRoutePatterns() == null || item.getRoutePatterns().isEmpty()) {
            response.addValidationError("The Route with ID='" + item.getId() + "' must contain at least one Route Pattern.");
        }
        for (String regexp : item.getRoutePatterns()) {
            if (this.isValidRegexp(regexp)) continue;
            response.addValidationError("The regexp in Route with ID='" + item.getId() + "' is not valid: " + regexp);
        }
        if (context.getExistingPathMappingIds() != null) {
            context.getExistingPathMappingIds().add(item.getId());
        }
        if (!("inclusive".equals(item.getRouteType()) || "exclusive".equals(item.getRouteType()) || "blocking".equals(item.getRouteType()))) {
            response.addValidationError("The groupMapping pattern with ID=" + item.getId() + " have invalid routeType='" + item.getRouteType() + "'. Valid route types are '" + "inclusive" + "', '" + "exclusive" + "' and '" + "blocking" + "'.");
        }
        if (!"blocking".equals(item.getRouteType())) {
            // empty if block
        }
        if (context.getExistingRepositoryIds() != null && context.getExistingRepositoryShadowIds() != null) {
            List<String> existingReposes = context.getExistingRepositoryIds();
            List<String> existingShadows = context.getExistingRepositoryShadowIds();
            for (String repoId : item.getRepositories()) {
                if (existingReposes.contains(repoId) || existingShadows.contains(repoId)) continue;
                response.addValidationError("The groupMapping pattern with ID=" + item.getId() + " refers to a nonexistent repository with repoID = " + repoId);
            }
        }
        return response;
    }
}

