/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.model;

import com.google.common.base.Preconditions;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.ExternalConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.AbstractCoreConfiguration;
import org.sonatype.nexus.configuration.model.AbstractXpp3DomExternalConfigurationHolder;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.configuration.model.Configuration;
import org.sonatype.nexus.configuration.model.DefaultExternalConfiguration;
import org.sonatype.nexus.configuration.validator.ApplicationValidationResponse;
import org.sonatype.nexus.proxy.repository.LocalStatus;

public class CRepositoryCoreConfiguration
extends AbstractCoreConfiguration<CRepository> {
    private static final String REPOSITORY_ID_PATTERN = "^[a-zA-Z0-9_\\-\\.]+$";
    private final CRepository repositoryModel;
    private final CRepositoryExternalConfigurationHolderFactory<?> externalConfigurationFactory;
    private ExternalConfiguration<?> externalConfiguration;

    public CRepositoryCoreConfiguration(ApplicationConfiguration configuration, CRepository repositoryModel, CRepositoryExternalConfigurationHolderFactory<?> extFactory) {
        super(configuration);
        this.setOriginalConfiguration(repositoryModel);
        this.repositoryModel = (CRepository)Preconditions.checkNotNull((Object)repositoryModel);
        this.externalConfigurationFactory = extFactory;
    }

    @Override
    protected void copyTransients(CRepository source, CRepository destination) {
        destination.setExternalConfiguration(source.getExternalConfiguration());
        destination.externalConfigurationImple = source.externalConfigurationImple;
        destination.defaultLocalStorageUrl = source.defaultLocalStorageUrl;
        if (source.getRemoteStorage() == null) {
            destination.setRemoteStorage(null);
        }
    }

    public ExternalConfiguration<?> getExternalConfiguration() {
        if (this.externalConfiguration == null) {
            this.externalConfiguration = this.prepareExternalConfiguration((CRepository)this.getOriginalConfiguration());
        }
        return this.externalConfiguration;
    }

    protected ExternalConfiguration<?> prepareExternalConfiguration(CRepository configuration) {
        if (this.externalConfigurationFactory == null) {
            return null;
        }
        if (this.repositoryModel.getExternalConfiguration() == null) {
            this.repositoryModel.setExternalConfiguration((Object)new Xpp3Dom("externalConfiguration"));
        }
        if (this.repositoryModel.externalConfigurationImple == null) {
            this.repositoryModel.externalConfigurationImple = this.externalConfigurationFactory.createExternalConfigurationHolder(this.repositoryModel);
        }
        return new DefaultExternalConfiguration<AbstractXpp3DomExternalConfigurationHolder>(this.getApplicationConfiguration(), this, (AbstractXpp3DomExternalConfigurationHolder)this.repositoryModel.externalConfigurationImple);
    }

    @Override
    protected CRepository extractConfiguration(Configuration configuration) {
        return null;
    }

    @Override
    public boolean isDirty() {
        return this.isThisDirty() || this.getExternalConfiguration() != null && this.getExternalConfiguration().isDirty();
    }

    @Override
    public void validateChanges() throws ConfigurationException {
        super.validateChanges();
        if (this.getExternalConfiguration() != null) {
            this.getExternalConfiguration().validateChanges();
        }
    }

    @Override
    public void commitChanges() throws ConfigurationException {
        super.commitChanges();
        if (this.getExternalConfiguration() != null) {
            this.getExternalConfiguration().commitChanges();
        }
    }

    @Override
    public void rollbackChanges() {
        super.rollbackChanges();
        if (this.getExternalConfiguration() != null) {
            this.getExternalConfiguration().rollbackChanges();
        }
    }

    @Override
    public ValidationResponse doValidateChanges(CRepository changedConfiguration) {
        CRepository cfg = changedConfiguration;
        ApplicationValidationResponse response = new ApplicationValidationResponse();
        if (StringUtils.isBlank((String)cfg.getId())) {
            response.addValidationError(new ValidationMessage("id", "Repository ID must not be blank!"));
        } else if (!cfg.getId().matches(REPOSITORY_ID_PATTERN)) {
            response.addValidationError(new ValidationMessage("id", "Only letters, digits, underscores, hyphens, and dots are allowed in Repository ID"));
        }
        if ("all".equals(cfg.getId())) {
            response.addValidationError(new ValidationMessage("id", "Repository ID can't be 'all', reserved word"));
        }
        if (StringUtils.isBlank((String)cfg.getName())) {
            response.addValidationWarning(new ValidationMessage("id", "Repository with ID='" + cfg.getId() + "' has no name, defaulted it's name to it's ID."));
            cfg.setName(cfg.getId());
            response.setModified(true);
        }
        try {
            LocalStatus.valueOf(cfg.getLocalStatus());
        }
        catch (Exception e) {
            response.addValidationError(new ValidationMessage("localStatus", "LocalStatus of repository with ID=\"" + cfg.getId() + "\" has unacceptable value \"" + cfg.getLocalStatus() + "\"! (Allowed values are: \"" + (Object)((Object)LocalStatus.IN_SERVICE) + "\" and \"" + (Object)((Object)LocalStatus.OUT_OF_SERVICE) + "\")", (Throwable)e));
        }
        if (cfg.isIndexable() && !"maven2".equals(cfg.getProviderHint())) {
            response.addValidationWarning(new ValidationMessage("indexable", "Indexing isn't supported for \"" + cfg.getProviderHint() + "\" repositories, only Maven2 repositories are indexable!"));
            cfg.setIndexable(false);
            response.setModified(true);
        }
        if (("maven2".equals(cfg.getProviderHint()) || "maven1".equals(cfg.getProviderHint())) && cfg.getRemoteStorage() != null && cfg.getRemoteStorage().getUrl() != null && !cfg.getRemoteStorage().getUrl().endsWith("/")) {
            cfg.getRemoteStorage().setUrl(cfg.getRemoteStorage().getUrl() + "/");
        }
        return response;
    }
}

