/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.model;

import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.AbstractCoreConfiguration;
import org.sonatype.nexus.configuration.model.CRemoteProxySettings;
import org.sonatype.nexus.configuration.model.Configuration;

public class CRemoteProxySettingsCoreConfiguration
extends AbstractCoreConfiguration<CRemoteProxySettings> {
    private boolean nullified;

    public CRemoteProxySettingsCoreConfiguration(ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
    }

    @Override
    protected CRemoteProxySettings extractConfiguration(Configuration configuration) {
        return configuration.getRemoteProxySettings();
    }

    public void initConfig() {
        CRemoteProxySettings newProxy = new CRemoteProxySettings();
        this.getApplicationConfiguration().getConfigurationModel().setRemoteProxySettings(newProxy);
        this.setOriginalConfiguration(newProxy);
    }

    public void nullifyConfig() {
        this.setChangedConfiguration(null);
        this.setOriginalConfiguration(null);
        this.nullified = true;
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.nullified;
    }

    @Override
    public void commitChanges() throws ConfigurationException {
        if (this.nullified) {
            this.getApplicationConfiguration().getConfigurationModel().setRemoteProxySettings(null);
        } else {
            super.commitChanges();
        }
        this.nullified = false;
    }

    @Override
    public void rollbackChanges() {
        super.rollbackChanges();
        this.nullified = false;
    }

    @Override
    protected void copyTransients(CRemoteProxySettings source, CRemoteProxySettings destination) {
        super.copyTransients(source, destination);
        if (source.getHttpProxySettings() == null) {
            destination.setHttpProxySettings(null);
        }
        if (source.getHttpsProxySettings() == null) {
            destination.setHttpsProxySettings(null);
        }
    }
}

