/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.model;

import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.AbstractCoreConfiguration;
import org.sonatype.nexus.configuration.model.CRestApiSettings;
import org.sonatype.nexus.configuration.model.Configuration;

public class CGlobalRestApiCoreConfiguration
extends AbstractCoreConfiguration<CRestApiSettings> {
    private boolean nullified;

    public CGlobalRestApiCoreConfiguration(ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
    }

    @Override
    protected CRestApiSettings extractConfiguration(Configuration configuration) {
        return configuration.getRestApi();
    }

    public void nullifyConfig() {
        this.setChangedConfiguration(null);
        this.setOriginalConfiguration(null);
        this.nullified = true;
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.nullified;
    }

    @Override
    public void commitChanges() throws ConfigurationException {
        if (this.nullified) {
            this.getApplicationConfiguration().getConfigurationModel().setRestApi(null);
        } else {
            super.commitChanges();
        }
        this.nullified = false;
    }

    @Override
    public void rollbackChanges() {
        super.rollbackChanges();
        this.nullified = false;
    }

    public void initConfig() {
        CRestApiSettings restApiSettings = new CRestApiSettings();
        this.getApplicationConfiguration().getConfigurationModel().setRestApi(restApiSettings);
        this.setOriginalConfiguration(restApiSettings);
    }
}

