/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.model;

import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.AbstractCoreConfiguration;
import org.sonatype.nexus.configuration.model.CRemoteConnectionSettings;
import org.sonatype.nexus.configuration.model.Configuration;

public class CGlobalRemoteConnectionSettingsCoreConfiguration
extends AbstractCoreConfiguration<CRemoteConnectionSettings> {
    public CGlobalRemoteConnectionSettingsCoreConfiguration(ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
    }

    @Override
    public CRemoteConnectionSettings getConfiguration(boolean forWrite) {
        if (this.getOriginalConfiguration() == null) {
            CRemoteConnectionSettings newConn = new CRemoteConnectionSettings();
            newConn.setConnectionTimeout(20000);
            newConn.setRetrievalRetryCount(3);
            this.getApplicationConfiguration().getConfigurationModel().setGlobalConnectionSettings(newConn);
            this.setOriginalConfiguration(newConn);
        }
        return (CRemoteConnectionSettings)super.getConfiguration(forWrite);
    }

    @Override
    protected CRemoteConnectionSettings extractConfiguration(Configuration configuration) {
        return configuration.getGlobalConnectionSettings();
    }

    @Override
    protected void copyTransients(CRemoteConnectionSettings source, CRemoteConnectionSettings destination) {
        super.copyTransients(source, destination);
        if (source.getQueryString() == null) {
            destination.setQueryString(null);
        }
        if (source.getUserAgentCustomizationString() == null) {
            destination.setUserAgentCustomizationString(null);
        }
    }
}

