/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.reflection.Reflector;
import org.codehaus.plexus.util.reflection.ReflectorException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.CoreConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.util.Inflector;

public abstract class AbstractXpp3DomExternalConfigurationHolder
implements Cloneable {
    private final Xpp3Dom configuration;
    private static final Reflector reflector = new Reflector();

    public AbstractXpp3DomExternalConfigurationHolder(Xpp3Dom configuration) {
        this.configuration = configuration;
    }

    public Xpp3Dom getRootNode() {
        return this.configuration;
    }

    public void apply(AbstractXpp3DomExternalConfigurationHolder configHolder) {
        Xpp3Dom newConfig = configHolder.getRootNode();
        while (this.configuration.getChildCount() > 0) {
            this.configuration.removeChild(0);
        }
        for (int i = 0; i < newConfig.getChildCount(); ++i) {
            this.configuration.addChild(newConfig.getChild(i));
        }
    }

    public Object clone() {
        try {
            return reflector.newInstance(this.getClass(), new Object[]{this.copyTree(this.configuration)});
        }
        catch (ReflectorException e) {
            throw new IllegalArgumentException("AbstractExternalConfigurationHolder class sublasses must have contructor that takes Xpp3Dom! This instance \"" + this.getClass().getName() + "\" does not have it!", e);
        }
    }

    public final void validate(ApplicationConfiguration applicationConfiguration, CoreConfiguration owner) throws ConfigurationException {
        this.checkValidationResponse(this.doValidateChanges(applicationConfiguration, owner, this.configuration));
    }

    public abstract ValidationResponse doValidateChanges(ApplicationConfiguration var1, CoreConfiguration var2, Xpp3Dom var3);

    protected void checkValidationResponse(ValidationResponse response) throws ConfigurationException {
        if (!response.isValid()) {
            throw new InvalidConfigurationException(response);
        }
    }

    protected Xpp3Dom copyTree(Xpp3Dom root) {
        Xpp3Dom clone = new Xpp3Dom(root.getName());
        for (String string : root.getAttributeNames()) {
            clone.setAttribute(string, root.getAttribute(string));
        }
        clone.setValue(root.getValue());
        for (String string : root.getChildren()) {
            Xpp3Dom cloneChild = this.copyTree((Xpp3Dom)string);
            clone.addChild(cloneChild);
        }
        return clone;
    }

    protected String getNodeValue(Xpp3Dom parent, String name, String defaultValue) {
        Xpp3Dom node = parent.getChild(name);
        if (node == null) {
            return defaultValue;
        }
        return node.getValue();
    }

    protected void setNodeValue(Xpp3Dom parent, String name, String value) {
        Xpp3Dom node = parent.getChild(name);
        if (node == null) {
            node = new Xpp3Dom(name);
            parent.addChild(node);
        }
        node.setValue(value);
    }

    protected List<String> getCollection(Xpp3Dom parent, String name) {
        Xpp3Dom node = parent.getChild(name);
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(node.getChildCount());
        for (Xpp3Dom child : node.getChildren()) {
            result.add(child.getValue());
        }
        return Collections.unmodifiableList(result);
    }

    protected void setCollection(Xpp3Dom parent, String name, Collection<String> values) {
        Xpp3Dom node = parent.getChild(name);
        if (node == null) {
            node = new Xpp3Dom(name);
            parent.addChild(node);
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            node.removeChild(i);
        }
        String childName = Inflector.getInstance().singularize(name);
        for (String childVal : values) {
            Xpp3Dom child = new Xpp3Dom(childName);
            child.setValue(childVal);
            node.addChild(child);
        }
    }

    protected boolean addToCollection(Xpp3Dom parent, String name, String value, boolean keepUnique) {
        Xpp3Dom node = parent.getChild(name);
        if (node == null) {
            node = new Xpp3Dom(name);
            parent.addChild(node);
        }
        if (keepUnique) {
            for (Xpp3Dom child : node.getChildren()) {
                if (!StringUtils.equals((String)value, (String)child.getValue())) continue;
                return false;
            }
        }
        String childName = Inflector.getInstance().singularize(name);
        Xpp3Dom child = new Xpp3Dom(childName);
        child.setValue(value);
        node.addChild(child);
        return true;
    }

    protected boolean removeFromCollection(Xpp3Dom parent, String name, String value) {
        Xpp3Dom node = parent.getChild(name);
        if (node == null) {
            return false;
        }
        ArrayList<String> children = new ArrayList<String>();
        boolean removed = false;
        for (Xpp3Dom child : node.getChildren()) {
            if (!StringUtils.equals((String)value, (String)child.getValue())) {
                children.add(child.getValue());
                continue;
            }
            removed = true;
        }
        this.setCollection(parent, name, children);
        return removed;
    }
}

