/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.model;

import com.thoughtworks.xstream.XStream;
import java.util.Collection;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.RevertableConfiguration;

public abstract class AbstractRevertableConfiguration<C>
implements RevertableConfiguration<C> {
    private final XStream xstream = new XStream();
    private volatile C originalConfiguration;
    private volatile C changedConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C getConfiguration(boolean forWrite) {
        if (forWrite) {
            AbstractRevertableConfiguration abstractRevertableConfiguration = this;
            synchronized (abstractRevertableConfiguration) {
                if (this.getOriginalConfiguration() != null && this.getChangedConfiguration() == null) {
                    C copy = this.copyObject(this.getOriginalConfiguration(), null);
                    this.copyTransients(this.getOriginalConfiguration(), copy);
                    this.setChangedConfiguration(copy);
                }
            }
            return this.getChangedConfiguration();
        }
        return this.getOriginalConfiguration();
    }

    protected XStream getXStream() {
        return this.xstream;
    }

    protected C getOriginalConfiguration() {
        return this.originalConfiguration;
    }

    public void setOriginalConfiguration(C originalConfiguration) {
        this.originalConfiguration = originalConfiguration;
    }

    protected C getChangedConfiguration() {
        return this.changedConfiguration;
    }

    public void setChangedConfiguration(C changedConfiguration) {
        this.changedConfiguration = changedConfiguration;
    }

    protected C copyObject(C source, C target) {
        if (source == null && target == null) {
            return null;
        }
        if (source instanceof Collection && target != null) {
            ((Collection)target).clear();
            ((Collection)target).addAll((Collection)source);
            return target;
        }
        if (target == null) {
            return (C)this.getXStream().fromXML(this.getXStream().toXML(source));
        }
        return (C)this.getXStream().fromXML(this.getXStream().toXML(source), target);
    }

    protected void copyTransients(C source, C destination) {
    }

    protected boolean isThisDirty() {
        return this.getChangedConfiguration() != null;
    }

    public boolean isDirty() {
        return this.isThisDirty();
    }

    public void validateChanges() throws ConfigurationException {
        if (this.isThisDirty()) {
            this.checkValidationResponse(this.doValidateChanges(this.getChangedConfiguration()));
        }
    }

    public synchronized void commitChanges() throws ConfigurationException {
        if (this.isThisDirty()) {
            try {
                this.checkValidationResponse(this.doValidateChanges(this.getChangedConfiguration()));
            }
            catch (ConfigurationException e) {
                this.rollbackChanges();
                throw e;
            }
            this.copyObject(this.getChangedConfiguration(), this.getOriginalConfiguration());
            this.copyTransients(this.getChangedConfiguration(), this.getOriginalConfiguration());
            this.setChangedConfiguration(null);
        }
    }

    public void rollbackChanges() {
        if (this.isThisDirty()) {
            this.setChangedConfiguration(null);
        }
    }

    protected void checkValidationResponse(ValidationResponse response) throws ConfigurationException {
        if (response != null && !response.isValid()) {
            throw new InvalidConfigurationException(response);
        }
    }

    protected ValidationResponse doValidateChanges(C changedConfiguration) {
        return new ValidationResponse();
    }
}

