/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.application.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.SingleVersionUpgrader;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.nexus.configuration.model.v2_5_0.io.xpp3.NexusConfigurationXpp3Reader;
import org.sonatype.nexus.configuration.model.v2_7_0.CProps;
import org.sonatype.nexus.configuration.model.v2_7_0.CScheduledTask;
import org.sonatype.nexus.configuration.model.v2_7_0.CSmtpConfiguration;
import org.sonatype.nexus.configuration.model.v2_7_0.Configuration;
import org.sonatype.nexus.configuration.model.v2_7_0.upgrade.BasicVersionUpgrade;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named(value="2.5.0")
public class Upgrade250to270
extends ComponentSupport
implements SingleVersionUpgrader {
    public Object loadConfiguration(File file) throws IOException, ConfigurationIsCorruptedException {
        org.sonatype.nexus.configuration.model.v2_5_0.Configuration conf = null;
        try (FileReader fr = new FileReader(file);){
            NexusConfigurationXpp3Reader reader = new NexusConfigurationXpp3Reader();
            conf = reader.read((Reader)fr);
        }
        catch (XmlPullParserException e) {
            throw new ConfigurationIsCorruptedException(file.getAbsolutePath(), (Throwable)e);
        }
        return conf;
    }

    public void upgrade(UpgradeMessage message) throws ConfigurationIsCorruptedException {
        org.sonatype.nexus.configuration.model.v2_5_0.Configuration oldc = (org.sonatype.nexus.configuration.model.v2_5_0.Configuration)message.getConfiguration();
        BasicVersionUpgrade versionConverter = new BasicVersionUpgrade();
        Configuration newc = versionConverter.upgradeConfiguration(oldc);
        newc.setVersion("2.7.0");
        this.upgradeEmptyTrashTaskConfiguration(newc);
        this.updateSmtpSslTlsSettings(newc);
        message.setModelVersion("2.7.0");
        message.setConfiguration((Object)newc);
    }

    protected void upgradeEmptyTrashTaskConfiguration(Configuration conf) {
        List tasks = conf.getTasks();
        for (CScheduledTask task : tasks) {
            Map<String, String> taskConfig;
            if (!"EmptyTrashTask".equals(task.getType()) || (taskConfig = this.getMapFromConfigList(task.getProperties())).containsKey("repositoryId")) continue;
            taskConfig.put("repositoryId", "all_repo");
            task.setProperties(this.getConfigListFromMap(taskConfig));
        }
    }

    protected void updateSmtpSslTlsSettings(Configuration conf) {
        CSmtpConfiguration smtp = conf.getSmtpConfiguration();
        if (smtp != null && smtp.isSslEnabled() && smtp.isTlsEnabled()) {
            smtp.setSslEnabled(true);
            smtp.setTlsEnabled(false);
            this.log.warn("SMTP related configuration change happened: both SSL and TLS was set, updated to use SSL only, assuming that SMTP server port is set to a port where remote SMTP server accepts SSL connections.");
        }
    }

    protected Map<String, String> getMapFromConfigList(List<CProps> list) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)list.size());
        for (CProps props : list) {
            result.put(props.getKey(), props.getValue());
        }
        return result;
    }

    protected List<CProps> getConfigListFromMap(Map<String, String> map) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            CProps cprop = new CProps();
            cprop.setKey(entry.getKey());
            cprop.setValue(entry.getValue());
            result.add(cprop);
        }
        return result;
    }
}

