/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.application.upgrade;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.SingleVersionUpgrader;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.nexus.configuration.model.v2_2_0.CRemoteHttpProxySettings;
import org.sonatype.nexus.configuration.model.v2_2_0.Configuration;
import org.sonatype.nexus.configuration.model.v2_2_0.io.xpp3.NexusConfigurationXpp3Reader;
import org.sonatype.nexus.configuration.model.v2_5_0.CRemoteProxySettings;
import org.sonatype.nexus.configuration.model.v2_5_0.upgrade.BasicVersionUpgrade;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named(value="2.2.0")
public class Upgrade220to250
extends ComponentSupport
implements SingleVersionUpgrader {
    public Object loadConfiguration(File file) throws IOException, ConfigurationIsCorruptedException {
        Configuration conf = null;
        try (FileReader fr = new FileReader(file);){
            NexusConfigurationXpp3Reader reader = new NexusConfigurationXpp3Reader();
            conf = reader.read((Reader)fr);
        }
        catch (XmlPullParserException e) {
            throw new ConfigurationIsCorruptedException(file.getAbsolutePath(), (Throwable)e);
        }
        return conf;
    }

    public void upgrade(UpgradeMessage message) throws ConfigurationIsCorruptedException {
        Configuration oldc = (Configuration)message.getConfiguration();
        BasicVersionUpgrade versionConverter = new BasicVersionUpgrade(){

            public org.sonatype.nexus.configuration.model.v2_5_0.CRemoteHttpProxySettings upgradeCRemoteHttpProxySettings(CRemoteHttpProxySettings cRemoteHttpProxySettings) {
                return super.upgradeCRemoteHttpProxySettings(cRemoteHttpProxySettings);
            }

            public org.sonatype.nexus.configuration.model.v2_5_0.Configuration upgradeConfiguration(Configuration oldConfig) {
                org.sonatype.nexus.configuration.model.v2_5_0.Configuration newConfig = super.upgradeConfiguration(oldConfig);
                if (oldConfig.getGlobalHttpProxySettings() != null) {
                    newConfig.setRemoteProxySettings(new CRemoteProxySettings());
                    newConfig.getRemoteProxySettings().setHttpProxySettings(this.upgradeCRemoteHttpProxySettings(oldConfig.getGlobalHttpProxySettings()));
                    newConfig.getRemoteProxySettings().setNonProxyHosts(oldConfig.getGlobalHttpProxySettings().getNonProxyHosts());
                }
                return newConfig;
            }
        };
        org.sonatype.nexus.configuration.model.v2_5_0.Configuration newc = versionConverter.upgradeConfiguration(oldc);
        newc.setVersion("2.5.0");
        message.setModelVersion("2.5.0");
        message.setConfiguration((Object)newc);
    }
}

