/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.application.upgrade;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.SingleVersionUpgrader;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.nexus.configuration.model.v2_0_0.CRemoteStorage;
import org.sonatype.nexus.configuration.model.v2_0_0.io.xpp3.NexusConfigurationXpp3Reader;
import org.sonatype.nexus.configuration.model.v2_2_0.Configuration;
import org.sonatype.nexus.configuration.model.v2_2_0.upgrade.BasicVersionUpgrade;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named(value="2.0.0")
public class Upgrade200to220
extends ComponentSupport
implements SingleVersionUpgrader {
    public Object loadConfiguration(File file) throws IOException, ConfigurationIsCorruptedException {
        org.sonatype.nexus.configuration.model.v2_0_0.Configuration conf = null;
        try (FileReader fr = null;){
            fr = new FileReader(file);
            NexusConfigurationXpp3Reader reader = new NexusConfigurationXpp3Reader();
            conf = reader.read((Reader)fr);
        }
        return conf;
    }

    public void upgrade(UpgradeMessage message) throws ConfigurationIsCorruptedException {
        org.sonatype.nexus.configuration.model.v2_0_0.Configuration oldc = (org.sonatype.nexus.configuration.model.v2_0_0.Configuration)message.getConfiguration();
        BasicVersionUpgrade versionConverter = new BasicVersionUpgrade(){

            public org.sonatype.nexus.configuration.model.v2_2_0.CRemoteStorage upgradeCRemoteStorage(CRemoteStorage cRemoteStorage) {
                org.sonatype.nexus.configuration.model.v2_2_0.CRemoteStorage remoteStorage = super.upgradeCRemoteStorage(cRemoteStorage);
                if (remoteStorage != null && StringUtils.equals((String)remoteStorage.getProvider(), (String)"apacheHttpClient3x")) {
                    remoteStorage.setProvider(null);
                }
                return remoteStorage;
            }
        };
        Configuration newc = versionConverter.upgradeConfiguration(oldc);
        newc.setVersion("2.2.0");
        message.setModelVersion("2.2.0");
        message.setConfiguration((Object)newc);
    }
}

