/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.application.upgrade;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.configuration.upgrade.ConfigurationIsCorruptedException;
import org.sonatype.configuration.upgrade.SingleVersionUpgrader;
import org.sonatype.configuration.upgrade.UnsupportedConfigurationVersionException;
import org.sonatype.configuration.upgrade.UpgradeMessage;
import org.sonatype.nexus.configuration.application.upgrade.ApplicationConfigurationUpgrader;
import org.sonatype.nexus.configuration.model.Configuration;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class DefaultApplicationConfigurationUpgrader
extends ComponentSupport
implements ApplicationConfigurationUpgrader {
    private final Map<String, SingleVersionUpgrader> upgraders;

    @Inject
    public DefaultApplicationConfigurationUpgrader(Map<String, SingleVersionUpgrader> upgraders) {
        this.upgraders = (Map)Preconditions.checkNotNull(upgraders);
    }

    @Override
    public Configuration loadOldConfiguration(File file) throws IOException, ConfigurationIsCorruptedException, UnsupportedConfigurationVersionException {
        SingleVersionUpgrader upgrader;
        String modelVersion = null;
        try {
            FileReader r = new FileReader(file);
            Xpp3Dom dom = Xpp3DomBuilder.build((Reader)r);
            modelVersion = dom.getChild("version").getValue();
        }
        catch (XmlPullParserException e) {
            throw new ConfigurationIsCorruptedException(file.getAbsolutePath(), (Throwable)e);
        }
        if ("2.8.0".equals(modelVersion)) {
            throw new ConfigurationIsCorruptedException(file);
        }
        UpgradeMessage msg = new UpgradeMessage();
        msg.setModelVersion(modelVersion);
        if ("1.0".equals(modelVersion)) {
            msg.setModelVersion("1.0.0");
        }
        if ((upgrader = this.upgraders.get(msg.getModelVersion())) != null) {
            this.log.debug("Upgrading old Nexus configuration file (version {}) at {}", (Object)msg.getModelVersion(), (Object)file.getAbsolutePath());
            msg.setConfiguration(upgrader.loadConfiguration(file));
            while (!"2.8.0".equals(msg.getModelVersion())) {
                if (upgrader == null) {
                    throw new UnsupportedConfigurationVersionException(modelVersion, file);
                }
                upgrader.upgrade(msg);
                upgrader = this.upgraders.get(msg.getModelVersion());
            }
            this.log.info("Nexus configuration file upgraded to current version {} successfully., ", (Object)msg.getModelVersion());
            return (Configuration)msg.getConfiguration();
        }
        throw new UnsupportedConfigurationVersionException(modelVersion, file);
    }
}

