/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.application.runtime;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.nexus.configuration.application.runtime.ApplicationRuntimeConfigurationBuilder;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class DefaultApplicationRuntimeConfigurationBuilder
extends ComponentSupport
implements ApplicationRuntimeConfigurationBuilder {
    private final BeanLocator beanLocator;

    @Inject
    public DefaultApplicationRuntimeConfigurationBuilder(BeanLocator beanLocator) {
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
    }

    @Override
    public Repository createRepository(Class<? extends Repository> type, String name) throws ConfigurationException {
        try {
            Provider rp = ((BeanEntry)this.beanLocator.locate(Key.get(type, (Annotation)Names.named((String)name))).iterator().next()).getProvider();
            return (Repository)rp.get();
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Could not lookup a new instance of Repository!", (Throwable)e);
        }
    }

    @Override
    public void releaseRepository(Repository repository) throws ConfigurationException {
        if (repository == null) {
            return;
        }
        repository.dispose();
    }
}

