/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.application;

import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;

public class RepositoryDependentException
extends ConfigurationException {
    private static final long serialVersionUID = -2037859093869479166L;
    private final Repository dependant;
    private final Repository repository;

    public RepositoryDependentException(Repository repository, Repository dependant) {
        super(String.format("Repository %s cannot be deleted due to dependency: repository %s.", RepositoryStringUtils.getHumanizedNameString(repository), RepositoryStringUtils.getHumanizedNameString(dependant)));
        this.repository = repository;
        this.dependant = dependant;
    }

    public Repository getDependant() {
        return this.dependant;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getUIMessage() {
        return String.format("Repository '%s' cannot be deleted due to dependencies on repository '%s'.\nDependencies must be removed in order to complete this operation.", RepositoryStringUtils.getHumanizedNameString(this.repository), RepositoryStringUtils.getHumanizedNameString(this.dependant));
    }
}

