/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.application;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.ConfigurationModifier;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.Configuration;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class NfcConfigurationModifier
extends ComponentSupport
implements ConfigurationModifier {
    private final String operation = SystemPropertiesHelper.getString("org.sonatype.nexus.configuration.application.NfcConfigurationModifier.enforce", null);

    @Override
    public boolean apply(Configuration configuration) {
        if (this.operation == null) {
            return false;
        }
        if (Boolean.parseBoolean(this.operation)) {
            this.doForceNfcSetting(configuration);
            return true;
        }
        this.undoForceNfcSetting(configuration);
        return true;
    }

    protected void doForceNfcSetting(Configuration configuration) {
        this.log.info("Enforcing proper NFC use: every non-proxy repository present in system will have NFC deactivated (system property override present).");
        for (CRepository repository : configuration.getRepositories()) {
            boolean isProxyRepository = repository.getRemoteStorage() != null && repository.getRemoteStorage().getUrl() != null;
            repository.setNotFoundCacheActive(isProxyRepository);
        }
    }

    protected void undoForceNfcSetting(Configuration configuration) {
        this.log.info("Undoing NFC overrides: every repository present in system will have NFC activated (system property override present).");
        for (CRepository repository : configuration.getRepositories()) {
            repository.setNotFoundCacheActive(true);
        }
    }
}

