/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.application;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationRequest;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.NexusStreamResponse;
import org.sonatype.nexus.configuration.Configurable;
import org.sonatype.nexus.configuration.ConfigurationChangeEvent;
import org.sonatype.nexus.configuration.ConfigurationCommitEvent;
import org.sonatype.nexus.configuration.ConfigurationLoadEvent;
import org.sonatype.nexus.configuration.ConfigurationPrepareForLoadEvent;
import org.sonatype.nexus.configuration.ConfigurationPrepareForSaveEvent;
import org.sonatype.nexus.configuration.ConfigurationRollbackEvent;
import org.sonatype.nexus.configuration.ConfigurationSaveEvent;
import org.sonatype.nexus.configuration.application.ApplicationDirectories;
import org.sonatype.nexus.configuration.application.ConfigurationModifier;
import org.sonatype.nexus.configuration.application.DefaultGlobalRemoteConnectionSettings;
import org.sonatype.nexus.configuration.application.DefaultGlobalRemoteProxySettings;
import org.sonatype.nexus.configuration.application.GlobalRemoteConnectionSettings;
import org.sonatype.nexus.configuration.application.GlobalRemoteProxySettings;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.configuration.application.RepositoryDependentException;
import org.sonatype.nexus.configuration.application.runtime.ApplicationRuntimeConfigurationBuilder;
import org.sonatype.nexus.configuration.model.CPathMappingItem;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.Configuration;
import org.sonatype.nexus.configuration.source.ApplicationConfigurationSource;
import org.sonatype.nexus.configuration.validator.ApplicationConfigurationValidator;
import org.sonatype.nexus.configuration.validator.ApplicationValidationContext;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.cache.CacheManager;
import org.sonatype.nexus.proxy.events.VetoFormatter;
import org.sonatype.nexus.proxy.events.VetoFormatterRequest;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.registry.RepositoryTypeDescriptor;
import org.sonatype.nexus.proxy.registry.RepositoryTypeRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.proxy.storage.local.DefaultLocalStorageContext;
import org.sonatype.nexus.proxy.storage.local.LocalStorageContext;
import org.sonatype.nexus.proxy.storage.remote.DefaultRemoteStorageContext;
import org.sonatype.nexus.proxy.storage.remote.RemoteStorageContext;
import org.sonatype.nexus.tasks.descriptors.ScheduledTaskDescriptor;
import org.sonatype.security.SecuritySystem;
import org.sonatype.security.authentication.AuthenticationException;
import org.sonatype.security.usermanagement.NoSuchUserManagerException;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.security.usermanagement.UserStatus;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class DefaultNexusConfiguration
extends ComponentSupport
implements NexusConfiguration {
    private final CacheManager cacheManager;
    private final EventBus eventBus;
    private final ApplicationConfigurationSource configurationSource;
    private final Provider<GlobalRemoteConnectionSettings> globalRemoteConnectionSettingsProvider;
    private final Provider<GlobalRemoteProxySettings> globalRemoteProxySettingsProvider;
    private final ApplicationConfigurationValidator configurationValidator;
    private final ApplicationRuntimeConfigurationBuilder runtimeConfigurationBuilder;
    private final RepositoryTypeRegistry repositoryTypeRegistry;
    private final RepositoryRegistry repositoryRegistry;
    private final List<ScheduledTaskDescriptor> scheduledTaskDescriptors;
    private final SecuritySystem securitySystem;
    private final VetoFormatter vetoFormatter;
    private final List<ConfigurationModifier> configurationModifiers;
    private final ClassLoader uberClassLoader;
    private final ApplicationDirectories applicationDirectories;
    private DefaultLocalStorageContext globalLocalStorageContext;
    private DefaultRemoteStorageContext globalRemoteStorageContext;
    private File configurationDirectory;
    private Map<String, String> configurationFiles;
    private int defaultRepositoryMaxInstanceCountLimit = Integer.MAX_VALUE;
    private Map<RepositoryTypeDescriptor, Integer> repositoryMaxInstanceCountLimits;

    @Inject
    public DefaultNexusConfiguration(CacheManager cacheManager, EventBus eventBus, @Named(value="file") ApplicationConfigurationSource configurationSource, Provider<GlobalRemoteConnectionSettings> globalRemoteConnectionSettingsProvider, Provider<GlobalRemoteProxySettings> globalRemoteProxySettingsProvider, ApplicationConfigurationValidator configurationValidator, ApplicationRuntimeConfigurationBuilder runtimeConfigurationBuilder, RepositoryTypeRegistry repositoryTypeRegistry, RepositoryRegistry repositoryRegistry, List<ScheduledTaskDescriptor> scheduledTaskDescriptors, SecuritySystem securitySystem, VetoFormatter vetoFormatter, List<ConfigurationModifier> configurationModifiers, @Named(value="nexus-uber") ClassLoader uberClassLoader, ApplicationDirectories applicationDirectories) {
        this.cacheManager = (CacheManager)Preconditions.checkNotNull((Object)cacheManager);
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.configurationSource = (ApplicationConfigurationSource)Preconditions.checkNotNull((Object)configurationSource);
        this.globalRemoteConnectionSettingsProvider = (Provider)Preconditions.checkNotNull(globalRemoteConnectionSettingsProvider);
        this.globalRemoteProxySettingsProvider = (Provider)Preconditions.checkNotNull(globalRemoteProxySettingsProvider);
        this.configurationValidator = (ApplicationConfigurationValidator)Preconditions.checkNotNull((Object)configurationValidator);
        this.runtimeConfigurationBuilder = (ApplicationRuntimeConfigurationBuilder)Preconditions.checkNotNull((Object)runtimeConfigurationBuilder);
        this.repositoryTypeRegistry = (RepositoryTypeRegistry)Preconditions.checkNotNull((Object)repositoryTypeRegistry);
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
        this.scheduledTaskDescriptors = (List)Preconditions.checkNotNull(scheduledTaskDescriptors);
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
        this.vetoFormatter = (VetoFormatter)Preconditions.checkNotNull((Object)vetoFormatter);
        this.configurationModifiers = (List)Preconditions.checkNotNull(configurationModifiers);
        this.uberClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)uberClassLoader);
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
        this.configurationDirectory = applicationDirectories.getWorkDirectory("conf");
    }

    @Override
    public void loadConfiguration() throws ConfigurationException, IOException {
        this.loadConfiguration(false);
    }

    @Override
    public synchronized void loadConfiguration(boolean force) throws ConfigurationException, IOException {
        if (force || this.configurationSource.getConfiguration() == null) {
            this.log.info("Loading Nexus Configuration...");
            this.configurationSource.loadConfiguration();
            boolean modified = false;
            for (ConfigurationModifier modifier : this.configurationModifiers) {
                modified |= modifier.apply((Configuration)this.configurationSource.getConfiguration());
            }
            if (modified) {
                this.configurationSource.backupConfiguration();
                this.configurationSource.storeConfiguration();
            }
            this.globalLocalStorageContext = new DefaultLocalStorageContext(null);
            this.globalRemoteStorageContext = new DefaultRemoteStorageContext(null);
            GlobalRemoteConnectionSettings globalRemoteConnectionSettings = (GlobalRemoteConnectionSettings)this.globalRemoteConnectionSettingsProvider.get();
            ((DefaultGlobalRemoteConnectionSettings)globalRemoteConnectionSettings).configure(this);
            this.globalRemoteStorageContext.setRemoteConnectionSettings(globalRemoteConnectionSettings);
            GlobalRemoteProxySettings globalRemoteProxySettings = (GlobalRemoteProxySettings)this.globalRemoteProxySettingsProvider.get();
            ((DefaultGlobalRemoteProxySettings)globalRemoteProxySettings).configure(this);
            this.globalRemoteStorageContext.setRemoteProxySettings(globalRemoteProxySettings);
            ConfigurationPrepareForLoadEvent loadEvent = new ConfigurationPrepareForLoadEvent(this);
            this.eventBus.post((Object)loadEvent);
            if (loadEvent.isVetoed()) {
                this.log.info(this.vetoFormatter.format(new VetoFormatterRequest(loadEvent, this.log.isDebugEnabled())));
                throw new ConfigurationException("The Nexus configuration is invalid!");
            }
            this.applyConfiguration();
            this.eventBus.post((Object)new ConfigurationLoadEvent(this));
        }
    }

    protected String changesToString(Collection<Configurable> changes) {
        StringBuilder sb = new StringBuilder();
        if (changes != null) {
            sb.append(Collections2.transform(changes, (Function)new Function<Configurable, String>(){

                public String apply(Configurable input) {
                    return input.getName();
                }
            }));
        }
        return sb.toString();
    }

    protected void logApplyConfiguration(Collection<Configurable> changes) {
        String userId = this.getCurrentUserId();
        if (changes != null && changes.size() > 0) {
            if (Strings.isNullOrEmpty((String)userId)) {
                this.log.info("Applying Nexus Configuration due to changes in {}...", (Object)this.changesToString(changes));
            } else {
                this.log.info("Applying Nexus Configuration due to changes in {} made by {}...", (Object)this.changesToString(changes), (Object)userId);
            }
        } else if (Strings.isNullOrEmpty((String)userId)) {
            this.log.info("Applying Nexus Configuration...");
        } else {
            this.log.info("Applying Nexus Configuration made by {}...", (Object)userId);
        }
    }

    protected String getCurrentUserId() {
        try {
            Subject subject = SecurityUtils.getSubject();
            if (subject != null && subject.getPrincipal() != null) {
                return subject.getPrincipal().toString();
            }
        }
        catch (Exception e) {
            this.log.warn("Could not obtain Shiro subject:", (Throwable)e);
        }
        return null;
    }

    public synchronized boolean applyConfiguration() {
        this.log.debug("Applying Nexus Configuration...");
        ConfigurationPrepareForSaveEvent prepare = new ConfigurationPrepareForSaveEvent(this);
        this.eventBus.post((Object)prepare);
        if (!prepare.isVetoed()) {
            this.logApplyConfiguration(prepare.getChanges());
            this.eventBus.post((Object)new ConfigurationCommitEvent(this));
            this.eventBus.post((Object)new ConfigurationChangeEvent(this, prepare.getChanges(), this.getCurrentUserId()));
            return true;
        }
        this.log.info(this.vetoFormatter.format(new VetoFormatterRequest(prepare, this.log.isDebugEnabled())));
        this.eventBus.post((Object)new ConfigurationRollbackEvent(this));
        return false;
    }

    @Override
    public synchronized void saveConfiguration() throws IOException {
        if (this.applyConfiguration()) {
            ValidationRequest request = new ValidationRequest(this.configurationSource.getConfiguration());
            ValidationResponse response = this.configurationValidator.validateModel(request);
            if (!response.isValid()) {
                this.log.error("Saving nexus configuration caused unexpected error:\n" + response.toString());
                throw new IOException("Saving nexus configuration caused unexpected error:\n" + response.toString());
            }
            this.configurationSource.storeConfiguration();
            this.eventBus.post((Object)new ConfigurationSaveEvent(this));
        }
    }

    @Override
    @Deprecated
    public Configuration getConfigurationModel() {
        return (Configuration)this.configurationSource.getConfiguration();
    }

    @Override
    public ApplicationConfigurationSource getConfigurationSource() {
        return this.configurationSource;
    }

    @Override
    public boolean isInstanceUpgraded() {
        return this.configurationSource.isInstanceUpgraded();
    }

    @Override
    public boolean isConfigurationUpgraded() {
        return this.configurationSource.isConfigurationUpgraded();
    }

    @Override
    public boolean isConfigurationDefaulted() {
        return this.configurationSource.isConfigurationDefaulted();
    }

    @Override
    public LocalStorageContext getGlobalLocalStorageContext() {
        return this.globalLocalStorageContext;
    }

    @Override
    public RemoteStorageContext getGlobalRemoteStorageContext() {
        return this.globalRemoteStorageContext;
    }

    @Override
    @Nullable
    @Deprecated
    public File getInstallDirectory() {
        return this.applicationDirectories.getInstallDirectory();
    }

    @Override
    @Deprecated
    public File getWorkingDirectory() {
        return this.applicationDirectories.getWorkDirectory();
    }

    @Override
    @Deprecated
    public File getWorkingDirectory(String key) {
        return this.applicationDirectories.getWorkDirectory(key);
    }

    @Override
    @Deprecated
    public File getWorkingDirectory(String key, boolean createIfNeeded) {
        return this.applicationDirectories.getWorkDirectory(key, createIfNeeded);
    }

    @Override
    @Deprecated
    public File getTemporaryDirectory() {
        return this.applicationDirectories.getTemporaryDirectory();
    }

    @Override
    public File getConfigurationDirectory() {
        return this.configurationDirectory;
    }

    @Override
    public List<ScheduledTaskDescriptor> listScheduledTaskDescriptors() {
        return Collections.unmodifiableList(this.scheduledTaskDescriptors);
    }

    @Override
    public ScheduledTaskDescriptor getScheduledTaskDescriptor(String id) {
        for (ScheduledTaskDescriptor descriptor : this.scheduledTaskDescriptors) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public void setRealms(List<String> realms) throws InvalidConfigurationException {
        this.getSecuritySystem().setRealms(realms);
    }

    @Override
    public boolean isAnonymousAccessEnabled() {
        return this.getSecuritySystem() != null && this.getSecuritySystem().isAnonymousAccessEnabled();
    }

    @Override
    public void setAnonymousAccess(boolean enabled, String username, String password) throws InvalidConfigurationException {
        if (enabled) {
            if (Strings.isNullOrEmpty((String)username) || Strings.isNullOrEmpty((String)password)) {
                throw new InvalidConfigurationException("Anonymous access is getting enabled without valid username and/or password!");
            }
            String oldUsername = this.getSecuritySystem().getAnonymousUsername();
            String oldPassword = this.getSecuritySystem().getAnonymousPassword();
            boolean statusChanged = this.setAnonymousUserEnabled(username, true);
            if (!Objects.equals(oldUsername, username) || !Objects.equals(oldPassword, password)) {
                try {
                    try {
                        this.securitySystem.getUser(username);
                        this.securitySystem.authenticate((AuthenticationToken)new UsernamePasswordToken(username, password));
                    }
                    catch (UserNotFoundException e) {
                        String msg = "User \"" + username + "'\" does not exist.";
                        this.log.warn("Nexus refused to apply configuration, the supplied anonymous information is wrong: " + msg, (Throwable)e);
                        throw new InvalidConfigurationException(msg, (Throwable)e);
                    }
                    catch (AuthenticationException e) {
                        String msg = "The password of user \"" + username + "\" is incorrect.";
                        this.log.warn("Nexus refused to apply configuration, the supplied anonymous information is wrong: " + msg, (Throwable)e);
                        throw new InvalidConfigurationException(msg, (Throwable)e);
                    }
                }
                catch (InvalidConfigurationException e) {
                    if (statusChanged) {
                        this.setAnonymousUserEnabled(username, false);
                    }
                    throw e;
                }
                this.getSecuritySystem().setAnonymousUsername(username);
                this.getSecuritySystem().setAnonymousPassword(password);
            }
            this.getSecuritySystem().setAnonymousAccessEnabled(true);
        } else {
            String existingUsername = this.getSecuritySystem().getAnonymousUsername();
            if (!Strings.isNullOrEmpty((String)existingUsername)) {
                this.setAnonymousUserEnabled(existingUsername, false);
            }
            this.getSecuritySystem().setAnonymousAccessEnabled(false);
        }
    }

    protected boolean setAnonymousUserEnabled(String anonymousUsername, boolean enabled) throws InvalidConfigurationException {
        try {
            User anonymousUser = this.getSecuritySystem().getUser(anonymousUsername, "default");
            UserStatus oldStatus = anonymousUser.getStatus();
            if (enabled) {
                anonymousUser.setStatus(UserStatus.active);
            } else {
                anonymousUser.setStatus(UserStatus.disabled);
            }
            this.getSecuritySystem().updateUser(anonymousUser);
            return !oldStatus.equals((Object)anonymousUser.getStatus());
        }
        catch (UserNotFoundException e) {
            this.log.debug("Anonymous user not found while trying to disable it (as part of disabling anonymous access)!", (Throwable)e);
            return false;
        }
        catch (NoSuchUserManagerException e) {
            this.log.debug("XML Realm not found while trying to disable Anonymous user (as part of disabling anonymous access)!", (Throwable)e);
            return false;
        }
        catch (InvalidConfigurationException e) {
            this.log.warn("XML Realm reported invalid configuration while trying to disable Anonymous user (as part of disabling anonymous access)!", (Throwable)e);
            throw e;
        }
    }

    @Override
    public String getAnonymousUsername() {
        return this.getSecuritySystem().getAnonymousUsername();
    }

    @Override
    public String getAnonymousPassword() {
        return this.getSecuritySystem().getAnonymousPassword();
    }

    @Override
    public List<String> getRealms() {
        return this.getSecuritySystem().getRealms();
    }

    @Override
    public void createInternals() throws ConfigurationException {
        this.createRepositories();
    }

    @Override
    public void dropInternals() {
        this.dropRepositories();
    }

    protected void createRepositories() throws ConfigurationException {
        List reposes = this.getConfigurationModel().getRepositories();
        for (CRepository repo : reposes) {
            if (repo.getProviderRole().equals(GroupRepository.class.getName())) continue;
            this.instantiateRepository(this.getConfigurationModel(), repo);
        }
        for (CRepository repo : reposes) {
            if (!repo.getProviderRole().equals(GroupRepository.class.getName())) continue;
            this.instantiateRepository(this.getConfigurationModel(), repo);
        }
    }

    protected void dropRepositories() {
        for (Repository repository : this.repositoryRegistry.getRepositories()) {
            try {
                this.repositoryRegistry.removeRepositorySilently(repository.getId());
            }
            catch (NoSuchRepositoryException noSuchRepositoryException) {}
        }
    }

    protected Repository instantiateRepository(Configuration configuration, CRepository repositoryModel) throws ConfigurationException {
        try {
            Class<?> klazz = this.uberClassLoader.loadClass(repositoryModel.getProviderRole());
            return this.instantiateRepository(configuration, klazz, repositoryModel.getProviderHint(), repositoryModel);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, ConfigurationException.class);
            throw new ConfigurationException("Cannot instantiate repository " + repositoryModel.getProviderRole() + ":" + repositoryModel.getProviderHint(), (Throwable)e);
        }
    }

    protected Repository instantiateRepository(Configuration configuration, Class<? extends Repository> klazz, String name, CRepository repositoryModel) throws ConfigurationException {
        this.checkRepositoryMaxInstanceCountForCreation(klazz, name, repositoryModel);
        Repository repository = this.runtimeConfigurationBuilder.createRepository(klazz, name);
        if (repository instanceof Configurable) {
            ((Configurable)repository).configure((Object)repositoryModel);
        }
        this.repositoryRegistry.addRepository(repository);
        return repository;
    }

    protected void releaseRepository(Repository repository, Configuration configuration, CRepository repositoryModel) throws ConfigurationException {
        this.runtimeConfigurationBuilder.releaseRepository(repository);
    }

    private ApplicationValidationContext getRepositoryValidationContext() {
        ApplicationValidationContext result = new ApplicationValidationContext();
        this.fillValidationContextRepositoryIds(result);
        return result;
    }

    private void fillValidationContextRepositoryIds(ApplicationValidationContext context) {
        context.addExistingRepositoryIds();
        List repositories = this.getConfigurationModel().getRepositories();
        if (repositories != null) {
            for (CRepository repo : repositories) {
                context.getExistingRepositoryIds().add(repo.getId());
            }
        }
    }

    protected Map<RepositoryTypeDescriptor, Integer> getRepositoryMaxInstanceCountLimits() {
        if (this.repositoryMaxInstanceCountLimits == null) {
            this.repositoryMaxInstanceCountLimits = new ConcurrentHashMap<RepositoryTypeDescriptor, Integer>();
        }
        return this.repositoryMaxInstanceCountLimits;
    }

    @Override
    public void setDefaultRepositoryMaxInstanceCount(int count) {
        if (count < 0) {
            this.log.info("Default repository maximal instance limit set to UNLIMITED.");
            this.defaultRepositoryMaxInstanceCountLimit = Integer.MAX_VALUE;
        } else {
            this.log.info("Default repository maximal instance limit set to " + count + ".");
            this.defaultRepositoryMaxInstanceCountLimit = count;
        }
    }

    @Override
    public void setRepositoryMaxInstanceCount(RepositoryTypeDescriptor rtd, int count) {
        if (count < 0) {
            this.log.info("Repository type " + rtd.toString() + " maximal instance limit set to UNLIMITED.");
            this.getRepositoryMaxInstanceCountLimits().remove(rtd);
        } else {
            this.log.info("Repository type " + rtd.toString() + " maximal instance limit set to " + count + ".");
            this.getRepositoryMaxInstanceCountLimits().put(rtd, count);
        }
    }

    @Override
    public int getRepositoryMaxInstanceCount(RepositoryTypeDescriptor rtd) {
        Integer limit = this.getRepositoryMaxInstanceCountLimits().get(rtd);
        if (null != limit) {
            return limit;
        }
        return this.defaultRepositoryMaxInstanceCountLimit;
    }

    protected void checkRepositoryMaxInstanceCountForCreation(Class<? extends Repository> klazz, String name, CRepository repositoryModel) throws ConfigurationException {
        RepositoryTypeDescriptor rtd = this.repositoryTypeRegistry.getRepositoryTypeDescriptor(klazz, name);
        if (null == rtd) {
            String msg = String.format("Repository \"%s\" (repoId=%s) corresponding type is not registered in Core, hence it's maxInstace check cannot be performed: Repository type %s:%s is unknown to Nexus Core. It is probably contributed by an old Nexus plugin. Please contact plugin developers to upgrade the plugin, and register the new repository type(s) properly!", repositoryModel.getName(), repositoryModel.getId(), repositoryModel.getProviderRole(), repositoryModel.getProviderHint());
            this.log.warn(msg);
            return;
        }
        int maxCount = rtd.getRepositoryMaxInstanceCount() != -1 ? rtd.getRepositoryMaxInstanceCount() : this.getRepositoryMaxInstanceCount(rtd);
        if (rtd.getInstanceCount() >= maxCount) {
            String msg = "Repository \"" + repositoryModel.getName() + "\" (id=" + repositoryModel.getId() + ") cannot be created. It's repository type " + rtd.toString() + " is limited to " + maxCount + " instances, and it already has " + String.valueOf(rtd.getInstanceCount()) + " of them.";
            this.log.warn(msg);
            throw new ConfigurationException(msg);
        }
    }

    protected void validateRepository(CRepository settings, boolean create) throws ConfigurationException {
        ValidationResponse vr;
        ApplicationValidationContext ctx = this.getRepositoryValidationContext();
        if (!create && !Strings.isNullOrEmpty((String)settings.getId())) {
            ctx.getExistingRepositoryIds().remove(settings.getId());
        }
        if (!(vr = this.configurationValidator.validateRepository(ctx, settings)).isValid()) {
            throw new InvalidConfigurationException(vr);
        }
    }

    @Override
    public synchronized Repository createRepository(CRepository settings) throws ConfigurationException, IOException {
        this.validateRepository(settings, true);
        Repository repository = this.instantiateRepository(this.getConfigurationModel(), settings);
        this.getConfigurationModel().addRepository(settings);
        this.saveConfiguration();
        return repository;
    }

    @Override
    public void deleteRepository(String id) throws NoSuchRepositoryException, IOException, ConfigurationException, AccessDeniedException {
        this.deleteRepository(id, false);
    }

    @Override
    public synchronized void deleteRepository(String id, boolean force) throws NoSuchRepositoryException, IOException, ConfigurationException, AccessDeniedException {
        Repository repository = this.repositoryRegistry.getRepository(id);
        if (!force && !repository.isUserManaged()) {
            throw new AccessDeniedException("Not allowed to delete non-user-managed repository '" + id + "'.");
        }
        repository.setLocalStatus(LocalStatus.OUT_OF_SERVICE);
        repository.setIndexable(false);
        repository.setSearchable(false);
        List<ShadowRepository> shadows = this.repositoryRegistry.getRepositoriesWithFacet(ShadowRepository.class);
        for (ShadowRepository shadow : shadows) {
            if (!repository.getId().equals(shadow.getMasterRepository().getId())) continue;
            throw new RepositoryDependentException(repository, shadow);
        }
        List pathMappings = this.getConfigurationModel().getRepositoryGrouping().getPathMappings();
        for (CPathMappingItem item : pathMappings) {
            item.removeRepository(id);
        }
        this.repositoryRegistry.removeRepository(id);
        List reposes = this.getConfigurationModel().getRepositories();
        Iterator i = reposes.iterator();
        while (i.hasNext()) {
            CRepository repo = (CRepository)i.next();
            if (!repo.getId().equals(id)) continue;
            i.remove();
            this.saveConfiguration();
            this.releaseRepository(repository, this.getConfigurationModel(), repo);
            return;
        }
        throw new NoSuchRepositoryException(id);
    }

    @Override
    public Map<String, String> getConfigurationFiles() {
        if (this.configurationFiles == null) {
            this.configurationFiles = new HashMap<String, String>();
            File configDirectory = this.getConfigurationDirectory();
            int key = 1;
            if (configDirectory.isDirectory() && configDirectory.listFiles() != null) {
                for (File file : configDirectory.listFiles()) {
                    if (!file.exists() || !file.isFile()) continue;
                    this.configurationFiles.put(Integer.toString(key), file.getName());
                    ++key;
                }
            }
        }
        return this.configurationFiles;
    }

    @Override
    public NexusStreamResponse getConfigurationAsStreamByKey(String key) throws IOException {
        String fileName = this.getConfigurationFiles().get(key);
        if (fileName != null) {
            File configFile = new File(this.getConfigurationDirectory(), fileName);
            if (configFile.canRead() && configFile.isFile()) {
                NexusStreamResponse response = new NexusStreamResponse();
                response.setName(fileName);
                if (fileName.endsWith(".xml")) {
                    response.setMimeType("text/xml");
                } else {
                    response.setMimeType("text/plain");
                }
                response.setSize(configFile.length());
                response.setFromByte(0L);
                response.setBytesCount(configFile.length());
                response.setInputStream(new FileInputStream(configFile));
                return response;
            }
            return null;
        }
        return null;
    }

    protected SecuritySystem getSecuritySystem() {
        return this.securitySystem;
    }
}

