/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.application;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.AbstractLastingConfigurable;
import org.sonatype.nexus.configuration.CoreConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.application.GlobalRestApiSettings;
import org.sonatype.nexus.configuration.model.CGlobalRestApiCoreConfiguration;
import org.sonatype.nexus.configuration.model.CRestApiSettings;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class DefaultGlobalRestApiSettings
extends AbstractLastingConfigurable<CRestApiSettings>
implements GlobalRestApiSettings {
    @Inject
    public DefaultGlobalRestApiSettings(EventBus eventBus, ApplicationConfiguration applicationConfiguration) {
        super("Global Rest Api Settings", eventBus, applicationConfiguration);
    }

    @Override
    protected void initializeConfiguration() throws ConfigurationException {
        if (this.getApplicationConfiguration().getConfigurationModel() != null) {
            this.configure(this.getApplicationConfiguration());
        }
    }

    @Override
    protected CoreConfiguration<CRestApiSettings> wrapConfiguration(Object configuration) throws ConfigurationException {
        if (configuration instanceof ApplicationConfiguration) {
            return new CGlobalRestApiCoreConfiguration((ApplicationConfiguration)configuration);
        }
        throw new ConfigurationException("The passed configuration object is of class \"" + configuration.getClass().getName() + "\" and not the required \"" + ApplicationConfiguration.class.getName() + "\"!");
    }

    protected void initConfig() {
        ((CGlobalRestApiCoreConfiguration)this.getCurrentCoreConfiguration()).initConfig();
    }

    @Override
    public void disable() {
        ((CGlobalRestApiCoreConfiguration)this.getCurrentCoreConfiguration()).nullifyConfig();
    }

    @Override
    public boolean isEnabled() {
        return this.getCurrentConfiguration(false) != null;
    }

    @Override
    public void setForceBaseUrl(boolean forceBaseUrl) {
        if (!this.isEnabled()) {
            this.initConfig();
        }
        ((CRestApiSettings)this.getCurrentConfiguration(true)).setForceBaseUrl(forceBaseUrl);
    }

    @Override
    public boolean isForceBaseUrl() {
        if (!this.isEnabled()) {
            return false;
        }
        return ((CRestApiSettings)this.getCurrentConfiguration(false)).isForceBaseUrl();
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        if (!this.isEnabled()) {
            this.initConfig();
        }
        ((CRestApiSettings)this.getCurrentConfiguration(true)).setBaseUrl(baseUrl);
    }

    @Override
    public String getBaseUrl() {
        if (!this.isEnabled()) {
            return null;
        }
        return ((CRestApiSettings)this.getCurrentConfiguration(false)).getBaseUrl();
    }

    @Override
    public void setUITimeout(int uiTimeout) {
        if (!this.isEnabled()) {
            this.initConfig();
        }
        ((CRestApiSettings)this.getCurrentConfiguration(true)).setUiTimeout(uiTimeout);
    }

    @Override
    public int getUITimeout() {
        if (!this.isEnabled()) {
            return 0;
        }
        return ((CRestApiSettings)this.getCurrentConfiguration(false)).getUiTimeout();
    }
}

