/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.application;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.AbstractLastingConfigurable;
import org.sonatype.nexus.configuration.CoreConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.application.AuthenticationInfoConverter;
import org.sonatype.nexus.configuration.application.GlobalRemoteProxySettings;
import org.sonatype.nexus.configuration.application.events.GlobalRemoteProxySettingsChangedEvent;
import org.sonatype.nexus.configuration.model.CRemoteHttpProxySettings;
import org.sonatype.nexus.configuration.model.CRemoteProxySettings;
import org.sonatype.nexus.configuration.model.CRemoteProxySettingsCoreConfiguration;
import org.sonatype.nexus.proxy.repository.DefaultRemoteHttpProxySettings;
import org.sonatype.nexus.proxy.repository.DefaultRemoteProxySettings;
import org.sonatype.nexus.proxy.repository.RemoteHttpProxySettings;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class DefaultGlobalRemoteProxySettings
extends AbstractLastingConfigurable<CRemoteProxySettings>
implements GlobalRemoteProxySettings {
    private final AuthenticationInfoConverter authenticationInfoConverter;

    @Inject
    public DefaultGlobalRemoteProxySettings(EventBus eventBus, ApplicationConfiguration applicationConfiguration, AuthenticationInfoConverter authenticationInfoConverter) {
        super("Global HTTP Proxy", eventBus, applicationConfiguration);
        this.authenticationInfoConverter = (AuthenticationInfoConverter)Preconditions.checkNotNull((Object)authenticationInfoConverter);
    }

    @Override
    protected CoreConfiguration<CRemoteProxySettings> wrapConfiguration(Object configuration) throws ConfigurationException {
        if (configuration instanceof ApplicationConfiguration) {
            return new CRemoteProxySettingsCoreConfiguration((ApplicationConfiguration)configuration);
        }
        throw new ConfigurationException("The passed configuration object is of class \"" + configuration.getClass().getName() + "\" and not the required \"" + ApplicationConfiguration.class.getName() + "\"!");
    }

    @Override
    public RemoteHttpProxySettings getHttpProxySettings() {
        if (this.isEnabled()) {
            try {
                return this.convertFromModel(((CRemoteProxySettings)this.getCurrentConfiguration(false)).getHttpProxySettings());
            }
            catch (ConfigurationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setHttpProxySettings(RemoteHttpProxySettings settings) {
        if (!this.isEnabled()) {
            this.initConfig();
        }
        ((CRemoteProxySettings)this.getCurrentConfiguration(true)).setHttpProxySettings(this.convertToModel(settings));
    }

    @Override
    public RemoteHttpProxySettings getHttpsProxySettings() {
        if (this.isEnabled()) {
            try {
                return this.convertFromModel(((CRemoteProxySettings)this.getCurrentConfiguration(false)).getHttpsProxySettings());
            }
            catch (ConfigurationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setHttpsProxySettings(RemoteHttpProxySettings settings) {
        if (!this.isEnabled()) {
            this.initConfig();
        }
        ((CRemoteProxySettings)this.getCurrentConfiguration(true)).setHttpsProxySettings(this.convertToModel(settings));
    }

    @Override
    public Set<String> getNonProxyHosts() {
        if (this.isEnabled()) {
            return new HashSet<String>(((CRemoteProxySettings)this.getCurrentConfiguration(false)).getNonProxyHosts());
        }
        return Collections.emptySet();
    }

    @Override
    public void setNonProxyHosts(Set<String> nonProxyHosts) {
        if (!this.isEnabled()) {
            this.initConfig();
        }
        ((CRemoteProxySettings)this.getCurrentConfiguration(true)).setNonProxyHosts(new ArrayList(nonProxyHosts == null ? Collections.emptySet() : nonProxyHosts));
    }

    @Override
    public RemoteHttpProxySettings getRemoteHttpProxySettingsFor(URL url) {
        return DefaultRemoteProxySettings.getRemoteHttpProxySettingsFor(url, this);
    }

    private RemoteHttpProxySettings convertFromModel(CRemoteHttpProxySettings model) throws ConfigurationException {
        if (model == null) {
            return null;
        }
        DefaultRemoteHttpProxySettings settings = new DefaultRemoteHttpProxySettings();
        settings.setHostname(model.getProxyHostname());
        settings.setPort(model.getProxyPort());
        settings.setProxyAuthentication(this.authenticationInfoConverter.convertAndValidateFromModel(model.getAuthentication()));
        return settings;
    }

    public CRemoteHttpProxySettings convertToModel(RemoteHttpProxySettings settings) {
        if (settings == null) {
            return null;
        }
        CRemoteHttpProxySettings model = new CRemoteHttpProxySettings();
        model.setProxyHostname(settings.getHostname());
        model.setProxyPort(settings.getPort());
        model.setAuthentication(this.authenticationInfoConverter.convertToModel(settings.getProxyAuthentication()));
        return model;
    }

    public void disable() {
        ((CRemoteProxySettingsCoreConfiguration)this.getCurrentCoreConfiguration()).nullifyConfig();
    }

    public boolean isEnabled() {
        return this.getCurrentConfiguration(false) != null;
    }

    protected void initConfig() {
        ((CRemoteProxySettingsCoreConfiguration)this.getCurrentCoreConfiguration()).initConfig();
    }

    @Override
    public boolean commitChanges() throws ConfigurationException {
        boolean wasDirty = super.commitChanges();
        if (wasDirty) {
            this.eventBus().post((Object)new GlobalRemoteProxySettingsChangedEvent(this));
        }
        return wasDirty;
    }
}

