/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.application;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.AbstractLastingConfigurable;
import org.sonatype.nexus.configuration.CoreConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.application.GlobalRemoteConnectionSettings;
import org.sonatype.nexus.configuration.application.events.GlobalRemoteConnectionSettingsChangedEvent;
import org.sonatype.nexus.configuration.model.CGlobalRemoteConnectionSettingsCoreConfiguration;
import org.sonatype.nexus.configuration.model.CRemoteConnectionSettings;
import org.sonatype.nexus.proxy.repository.DefaultRemoteConnectionSettings;
import org.sonatype.nexus.proxy.repository.RemoteConnectionSettings;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class DefaultGlobalRemoteConnectionSettings
extends AbstractLastingConfigurable<CRemoteConnectionSettings>
implements GlobalRemoteConnectionSettings {
    @Inject
    public DefaultGlobalRemoteConnectionSettings(EventBus eventBus, ApplicationConfiguration applicationConfiguration) {
        super("Global Remote Connection Settings", eventBus, applicationConfiguration);
    }

    @Override
    protected CoreConfiguration<CRemoteConnectionSettings> wrapConfiguration(Object configuration) throws ConfigurationException {
        if (configuration instanceof ApplicationConfiguration) {
            return new CGlobalRemoteConnectionSettingsCoreConfiguration((ApplicationConfiguration)configuration);
        }
        throw new ConfigurationException("The passed configuration object is of class \"" + configuration.getClass().getName() + "\" and not the required \"" + ApplicationConfiguration.class.getName() + "\"!");
    }

    @Override
    public int getConnectionTimeout() {
        return ((CRemoteConnectionSettings)this.getCurrentConfiguration(false)).getConnectionTimeout();
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        ((CRemoteConnectionSettings)this.getCurrentConfiguration(true)).setConnectionTimeout(connectionTimeout);
    }

    @Override
    public String getQueryString() {
        return ((CRemoteConnectionSettings)this.getCurrentConfiguration(false)).getQueryString();
    }

    @Override
    public void setQueryString(String queryString) {
        ((CRemoteConnectionSettings)this.getCurrentConfiguration(true)).setQueryString(queryString);
    }

    @Override
    public int getRetrievalRetryCount() {
        return ((CRemoteConnectionSettings)this.getCurrentConfiguration(false)).getRetrievalRetryCount();
    }

    @Override
    public void setRetrievalRetryCount(int retrievalRetryCount) {
        ((CRemoteConnectionSettings)this.getCurrentConfiguration(true)).setRetrievalRetryCount(retrievalRetryCount);
    }

    @Override
    public String getUserAgentCustomizationString() {
        return ((CRemoteConnectionSettings)this.getCurrentConfiguration(false)).getUserAgentCustomizationString();
    }

    @Override
    public void setUserAgentCustomizationString(String userAgentCustomizationString) {
        ((CRemoteConnectionSettings)this.getCurrentConfiguration(true)).setUserAgentCustomizationString(userAgentCustomizationString);
    }

    @Override
    public RemoteConnectionSettings convertAndValidateFromModel(CRemoteConnectionSettings model) throws ConfigurationException {
        if (model != null) {
            DefaultRemoteConnectionSettings remoteConnectionSettings = new DefaultRemoteConnectionSettings();
            remoteConnectionSettings.setConnectionTimeout(model.getConnectionTimeout());
            remoteConnectionSettings.setQueryString(model.getQueryString());
            remoteConnectionSettings.setRetrievalRetryCount(model.getRetrievalRetryCount());
            remoteConnectionSettings.setUserAgentCustomizationString(model.getUserAgentCustomizationString());
            return remoteConnectionSettings;
        }
        return null;
    }

    @Override
    public CRemoteConnectionSettings convertToModel(RemoteConnectionSettings settings) {
        if (settings == null) {
            return null;
        }
        CRemoteConnectionSettings model = new CRemoteConnectionSettings();
        model.setConnectionTimeout(settings.getConnectionTimeout());
        model.setQueryString(settings.getQueryString());
        model.setRetrievalRetryCount(settings.getRetrievalRetryCount());
        model.setUserAgentCustomizationString(settings.getUserAgentCustomizationString());
        return model;
    }

    @Override
    public boolean commitChanges() throws ConfigurationException {
        boolean wasDirty = super.commitChanges();
        if (wasDirty) {
            this.eventBus().post((Object)new GlobalRemoteConnectionSettingsChangedEvent(this));
        }
        return wasDirty;
    }
}

