/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.application;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.ApplicationDirectories;
import org.sonatype.nexus.util.file.DirSupport;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class ApplicationDirectoriesImpl
extends ComponentSupport
implements ApplicationDirectories {
    private final File installDir;
    private final File workDir;
    private final File tempDir;

    @Inject
    public ApplicationDirectoriesImpl(@Named(value="${bundleBasedir}") @Nullable File installDir, @Named(value="${nexus-work}") File workDir) {
        if (installDir != null) {
            this.installDir = this.resolve(installDir, false);
            this.log.debug("Install dir: {}", (Object)this.installDir);
        } else {
            this.installDir = null;
            this.log.debug("Install dir not available");
        }
        this.workDir = this.resolve(workDir, true);
        this.log.debug("Work dir: {}", (Object)this.workDir);
        String tmplocation = System.getProperty("java.io.tmpdir", "tmp");
        this.tempDir = this.resolve(new File(tmplocation), true);
        this.log.debug("Temp dir: {}", (Object)this.tempDir);
    }

    @Override
    @Nullable
    public File getInstallDirectory() {
        return this.installDir;
    }

    @Override
    public File getTemporaryDirectory() {
        return this.tempDir;
    }

    @Override
    public File getWorkDirectory() {
        return this.workDir;
    }

    @Override
    public File getWorkDirectory(String path, boolean create) {
        Preconditions.checkNotNull((Object)path);
        File dir = new File(this.workDir, path);
        return this.resolve(dir, create);
    }

    @Override
    public File getWorkDirectory(String path) {
        return this.getWorkDirectory(path, true);
    }

    private File resolve(File dir, boolean create) {
        Preconditions.checkNotNull((Object)dir);
        this.log.trace("Resolving directory: {}; create: {}", (Object)dir, (Object)create);
        try {
            dir = dir.getCanonicalFile();
        }
        catch (Exception e) {
            this.log.error("Failed to canonicalize directory: {}", (Object)dir);
            throw Throwables.propagate((Throwable)e);
        }
        if (create && !dir.isDirectory()) {
            try {
                DirSupport.mkdir(dir.toPath());
                this.log.debug("Created directory: {}", (Object)dir);
            }
            catch (Exception e) {
                this.log.error("Failed to create directory: {}", (Object)dir);
                throw Throwables.propagate((Throwable)e);
            }
        }
        return dir;
    }
}

