/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.application;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.configuration.model.Configuration;
import org.sonatype.nexus.proxy.storage.local.LocalStorageContext;
import org.sonatype.nexus.proxy.storage.remote.RemoteStorageContext;

@Singleton
@Named
public class ApplicationConfigurationAdapter
implements ApplicationConfiguration {
    private final NexusConfiguration nexusConfiguration;

    @Inject
    public ApplicationConfigurationAdapter(NexusConfiguration nexusConfiguration) {
        this.nexusConfiguration = (NexusConfiguration)Preconditions.checkNotNull((Object)nexusConfiguration);
    }

    @Override
    @Deprecated
    public Configuration getConfigurationModel() {
        return this.nexusConfiguration.getConfigurationModel();
    }

    @Override
    @Nullable
    public File getInstallDirectory() {
        return this.nexusConfiguration.getInstallDirectory();
    }

    @Override
    public File getWorkingDirectory() {
        return this.nexusConfiguration.getWorkingDirectory();
    }

    @Override
    public File getWorkingDirectory(String key) {
        return this.nexusConfiguration.getWorkingDirectory(key);
    }

    @Override
    public File getWorkingDirectory(String key, boolean createIfNeeded) {
        return this.nexusConfiguration.getWorkingDirectory(key, createIfNeeded);
    }

    @Override
    public File getTemporaryDirectory() {
        return this.nexusConfiguration.getTemporaryDirectory();
    }

    @Override
    public File getConfigurationDirectory() {
        return this.nexusConfiguration.getConfigurationDirectory();
    }

    @Override
    public void saveConfiguration() throws IOException {
        this.nexusConfiguration.saveConfiguration();
    }

    @Override
    public LocalStorageContext getGlobalLocalStorageContext() {
        return this.nexusConfiguration.getGlobalLocalStorageContext();
    }

    @Override
    public RemoteStorageContext getGlobalRemoteStorageContext() {
        return this.nexusConfiguration.getGlobalRemoteStorageContext();
    }
}

