/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;

@Singleton
@Named
public class PasswordHelper {
    private static final String ENC = "CMMDwoV";
    private final PlexusCipher plexusCipher;

    @Inject
    public PasswordHelper(PlexusCipher plexusCipher) {
        this.plexusCipher = (PlexusCipher)Preconditions.checkNotNull((Object)plexusCipher, (Object)"plexusCipher");
    }

    public String encrypt(String password) throws PlexusCipherException {
        return this.encrypt(password, ENC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encrypt(String password, String encoding) throws PlexusCipherException {
        if (this.plexusCipher.isEncryptedString(password)) {
            return password;
        }
        if (password != null) {
            PlexusCipher plexusCipher = this.plexusCipher;
            synchronized (plexusCipher) {
                return this.plexusCipher.encryptAndDecorate(password, encoding);
            }
        }
        return null;
    }

    public String decrypt(String encodedPassword) throws PlexusCipherException {
        return this.decrypt(encodedPassword, ENC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decrypt(String encodedPassword, String encoding) throws PlexusCipherException {
        if (!this.plexusCipher.isEncryptedString(encodedPassword)) {
            return encodedPassword;
        }
        if (encodedPassword != null) {
            PlexusCipher plexusCipher = this.plexusCipher;
            synchronized (plexusCipher) {
                return this.plexusCipher.decryptDecorated(encodedPassword, encoding);
            }
        }
        return null;
    }
}

